<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * AssignChiefDepartments Controller
 *
 * @property \App\Model\Table\AssignChiefDepartmentsTable $AssignChiefDepartments
 * @method \App\Model\Entity\AssignChiefDepartment[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class AssignChiefDepartmentsController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        if ($this->Authentication->getResult()->getData() && in_array($this->Authentication->getResult()->getData()->users_roles_id, ['cpo', 'pm', 'chief'])) {
            $this->Flash->error(__('Oops, you are not allowed that location'));

            $this->redirect(['controller' => 'Users', 'action' => 'view']);
        }
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $this->paginate = [
            'contain' => ['Users', 'Departments'],
        ];
        $query = $this->AssignChiefDepartments->find();
        $rees = $query->select()
                ->distinct(['user_id'])
                ->contain(['Users']);

//        debug($rees);exit;
        $assignChiefDepartments = $rees;
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['department_name' => 'asc']])->all()->toArray();

        $this->set(compact('assignChiefDepartments', 'departments'));
    }

    /**
     * View method
     *
     * @param string|null $id Assign Chief Department id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $assignChiefDepartment = $this->AssignChiefDepartments->get($id, [
            'contain' => ['Users', 'Departments'],
        ]);

        $this->set(compact('assignChiefDepartment'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $assignChiefDepartment = $this->AssignChiefDepartments->newEmptyEntity();
        if ($this->request->is('post')) {
//            debug($this->request->getData());
//            exit;
            if (isset($this->request->getData()['department_id'])) {

                foreach ($this->request->getData()['department_id'] as $data):

                    $articles = $this->getTableLocator()->get('AssignChiefDepartments');
                    $query = $articles->query();
                    $query->insert(['user_id', 'department_id', 'created'])
                            ->values([
                                'user_id' => $this->request->getData()['user_id'],
                                'department_id' => $data,
                                'created' => date('Y-m-d'),
                            ])
                            ->execute();
                endforeach;

//                $assignChiefDepartment = $this->AssignChiefDepartments->patchEntity($assignChiefDepartment, $this->request->getData());
//                if ($this->AssignChiefDepartments->save($assignChiefDepartment)) {
                $this->Flash->success(__('The assign chief department has been saved.'));
//
                return $this->redirect(['action' => 'index']);
//                }
//                $this->Flash->error(__('The assign chief department could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must Choose atleast 1 department'));
            }
        }

        $query = $this->AssignChiefDepartments->find();
        $rees = $query->select()
                ->distinct(['user_id'])
                ->contain(['Users']);
        $users_list = [];
        foreach ($rees as $r):
            array_push($users_list, $r->user_id);
        endforeach;

        $this->loadModel('Users');
        $users = $this->Users->find('list', ['conditions' => ['users_roles_id' => 'chief', 'id NOT IN' => $users_list,'deleted'=>0], 'limit' => 200]);

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['limit' => 200, 'order' => ['department_name' => 'asc'], 'conditions' => ['deleted' => 0]]);

        $this->set(compact('assignChiefDepartment', 'users', 'departments'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Assign Chief Department id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $assignChiefDepartments = $this->AssignChiefDepartments->find('all', ['conditions' => ['user_id' => $id]])->all();
        if ($this->request->is(['patch', 'post', 'put'])) {
            $this->AssignChiefDepartments->deleteAll(['user_id' => $id]);
            if (isset($this->request->getData()['department_id'])) {

                foreach ($this->request->getData()['department_id'] as $data):

                    $articles = $this->getTableLocator()->get('AssignChiefDepartments');
                    $query = $articles->query();
                    $query->insert(['user_id', 'department_id', 'created'])
                            ->values([
                                'user_id' => $this->request->getData()['user_id'],
                                'department_id' => $data,
                                'created' => date('Y-m-d'),
                            ])
                            ->execute();
                endforeach;

//                $assignChiefDepartment = $this->AssignChiefDepartments->patchEntity($assignChiefDepartment, $this->request->getData());
//                if ($this->AssignChiefDepartments->save($assignChiefDepartment)) {
                $this->Flash->success(__('The assign chief department has been saved.'));
//
                return $this->redirect(['action' => 'index']);
//                }
//                $this->Flash->error(__('The assign chief department could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must Choose atleast 1 department'));
            }
        }
       

        $this->loadModel('Users');
        $users = $this->Users->find('list', ['conditions' => ['users_roles_id' => 'chief', 'id IN' => $id,'deleted'=>0], 'limit' => 200]);

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['limit' => 200, 'order' => ['department_name' => 'asc'], 'conditions' => ['deleted' => 0]]);

        $this->set(compact('assignChiefDepartments', 'users', 'departments', 'id'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Assign Chief Department id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
//        $assignChiefDepartment = $this->AssignChiefDepartments->get($id);
        if ($this->AssignChiefDepartments->deleteAll(['user_id' => $id])) {
            $this->Flash->success(__('The assign chief department has been deleted.'));
        } else {
            $this->Flash->error(__('The assign chief department could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
