<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use Cake\Mailer\Email;
use App\Controller\AppController;

/**
 * Comments Controller
 *
 * @property \App\Model\Table\CommentsTable $Comments
 * @method \App\Model\Entity\Comment[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class CommentsController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        if ($this->Authentication->getResult()->getData() && in_array($this->Authentication->getResult()->getData()->users_roles_id, ['cpo', 'pm'])) {
            $this->Flash->error(__('Oops, you are not allowed that location'));

            $this->redirect(['controller' => 'Users', 'action' => 'view']);
        }
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $this->paginate = [
            'contain' => ['Departments', 'DepartmentSchemes'],
			'conditions' => ['Comments.parent_id' => 0]
            //'conditions' => ['Comments.user_id' => $this->request->getAttribute('identity')->getIdentifier()]
        ];
        $comments = $this->paginate($this->Comments);

        $this->set(compact('comments'));
    }

    public function exportexcel($id = null) {
        $output_type = 'D';

        $file = 'comments.xlsx';

        $this->loadModel('Comments');

        $comments = $this->Comments->find('all',['fields' => ['id','comments','created','user_id','Users.fname','Users.lname','Users.users_roles_id','DepartmentSchemes.scheme_name','Departments.department_name'], 'contain' => ['Departments', 'DepartmentSchemes','Users'], 'conditions' => ['Comments.parent_id' => 0]])->all()->toArray();
		$comments = json_decode(json_encode($comments));
		//echo '<pre>';print_r($comments);exit;

        $this->set(compact('comments'));
        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/exportexcel');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    /**
     * View method
     *
     * @param string|null $id Comment id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $comment = $this->Comments->get($id, [
            'contain' => ['Users', 'Departments', 'DepartmentSchemes'],
        ]);

        $this->set(compact('comment'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function savecomment() {
        if (isset($_POST['id']) && $_POST['id'] != '') {
            $comment_type = 'Old Comment has been updated by ';
            $departmentScheme = $this->Comments->get($_POST['id']);
        } else {
            $comment_type = 'A new comment has been added by ';
            $departmentScheme = $this->Comments->newEmptyEntity();
        }
		
        if ($this->request->is('post')) {

            $mPostData = $this->request->getData();

            $departmentScheme = $this->Comments->patchEntity($departmentScheme, $mPostData);
            $departmentScheme->user_id = $this->request->getAttribute('identity')->getIdentifier();

            if ($result = $this->Comments->save($departmentScheme)) {
				
				if(isset($_POST['parent_id'])){
					$this->Comments->updateAll(['parent_id' => $this->request->getData()['parent_id']], ['id in' => [$result->id]]);
				}
				
                $comment = $this->Comments->get($result->id, [
                    'contain' => ['Users', 'Departments', 'DepartmentSchemes'],
                ]);
				
                $this->loadModel('Users');
                $fetch_cpo = $this->Users->find('all', ['fields' => ['email', 'fname', 'lname', 'tel1'], 'conditions' => ['Users.department_id' => $_POST['department_id'], 'users_roles_id' => 'cpo']])->first();
                $this->sendemail($comment, $fetch_cpo, $comment_type);

                echo json_encode($comment);
            } else {
//                debug($departmentScheme);
                echo json_encode('not saved');
            }
        }
//        debug($_POST);
        exit;
    }

    private function sendemail($comment_details = null, $user_details = null, $comment_type = null) {
		//debug($comment_details);exit;
		if($_SERVER['HTTP_HOST'] != 'localhost'){
			$sender = ucwords($comment_details->user->fname . ' ' . $comment_details->user->lname);
			$email = new Email();
			$email->viewBuilder()->setTemplate('chiefcomments', 'default');
			$email->setEmailFormat('html')
					->setTo($user_details->email)
					//->setTo('ahsan.cc@gmail.com')
					->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
					//->setBcc('ahsan.cc@gmail.com')
					//->from($this->request->getData()['email'])
					->setSubject('cmdu.kp.gov.pk - ' . $comment_type . $sender)
					->setViewVars(['comment_details' => $comment_details, 'user_details' => $user_details, 'sender' => $sender, 'comment_type' => $comment_type])
					->send();
		}
		//echo "sent on " . date('Y-m-d h:i a') . ' to Admins.<br/>';
        //sms starts

        $this->loadComponent('Sms');
        if ($user_details->tel1) {
            $message = 'Dear ' . ucwords($user_details->fname . ' ' . $user_details->lname) . ', ' . $comment_type . $sender . ' for the scheme: ' . $comment_details->department_scheme->scheme_name;
            $message .= ', comment: "' . $comment_details->comments . '"';
            $this->Sms->sms(str_replace(' ', '', $user_details->tel1), $message);
			if($_SERVER['HTTP_HOST'] != 'localhost'){
				$this->Sms->sms("03339329637", $message);
			}else{
				$this->Sms->sms("03339325261", $message);
			}
        }
		//echo $response;
        //sms ends
    }

    public function add() {
        $comment = $this->Comments->newEmptyEntity();
        if ($this->request->is('post')) {
            $comment = $this->Comments->patchEntity($comment, $this->request->getData());
            $comment->user_id = $this->request->getAttribute('identity')->getIdentifier();

            if ($this->Comments->save($comment)) {
                $this->Flash->success(__('The comment has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The comment could not be saved. Please, try again.'));
        }
//        $users = $this->Comments->Users->find('list', ['deleted'=>0,'limit' => 200]);
        $departments = $this->Comments->Departments->find('list', ['deleted' => 0, 'limit' => 200]);
//        $departmentSchemes = $this->Comments->DepartmentSchemes->find('list', ['limit' => 200]);
        $this->set(compact('comment', 'departments'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Comment id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $comment = $this->Comments->get($id, [
            'conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $comment = $this->Comments->patchEntity($comment, $this->request->getData());
            if ($this->Comments->save($comment)) {
                $this->Flash->success(__('The comment has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The comment could not be saved. Please, try again.'));
        }
//        $users = $this->Comments->Users->find('list', ['limit' => 200]);
        $departments = $this->Comments->Departments->find('list', ['deleted' => 0, 'limit' => 200]);
        $departmentSchemes = $this->Comments->DepartmentSchemes->find('list', ['deleted' => 0, 'limit' => 200, 'conditions' => ['DepartmentSchemes.department_id' => $comment->department_id]]);
        $this->set(compact('comment', 'departments', 'departmentSchemes'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Comment id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $comment = $this->Comments->get($id);
        if ($this->Comments->delete($comment)) {
            $this->Flash->success(__('The comment has been deleted.'));
        } else {
            $this->Flash->error(__('The comment could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function deletecomment($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $comment = $this->Comments->get($_POST['id']);
        if ($this->Comments->delete($comment)) {
            $message = 'deleted';
        } else {
            $message = 'not_deleted';
        }
        echo json_encode($message);
        exit;
    }

}
