<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\I18n\FrozenTime;
use Cake\Mailer\Email;
use Cake\Datasource\ConnectionManager;

/**
 * RecordNotes Controller
 *
 * @property \App\Model\Table\RecordNotesTable $RecordNotes
 * @method \App\Model\Entity\RecordNote[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class RecordNotesController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $cond = array();
        if (isset($_GET['department'])) {
            $cond[] = ['RecordNotes.department_id IN' => $_GET['department']];

        }
        if (isset($_GET['overall_status']) && $_GET['overall_status'] !== '') {
            $cond[] = ['RecordNotes.overall_status' => $_GET['status']];
        }
         if (isset($_GET['name']) && $_GET['name'] !== '') {

            $cond[] = ['OR' => ['RecordNotes.subject like ' => '%' . $_GET['name'] . '%']];
        }
        $recordNotes = $this->paginate($this->RecordNotes, ['contain' => ['RecordNoteDetails']]);
        $this->loadModel('Users');
        $users = $this->Users->find('list', ['conditions' => ['users_roles_id' => 'admin'], 'limit' => 200, 'keyField' => 'id', 'valueField' => 'full_name'])->toArray();
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', [ 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();
        $this->set(compact('recordNotes', 'users','departments'));
    }

    /**
     * View method
     *
     * @param string|null $id Record Note id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $recordNote = $this->RecordNotes->get($id, [
            'contain' => ['RecordNoteDetails'],
        ]);

        $this->set(compact('recordNote'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $recordNote = $this->RecordNotes->newEmptyEntity();
        if ($this->request->is('post')) {

            $mPostData = $this->request->getData();
//            debug($mPostData);
//            exit;
//            unset($mPostData['attachment']);

            $recordNote = $this->RecordNotes->patchEntity($recordNote, $this->request->getData());
            $recordNote->created_by = $this->request->getAttribute('identity')->getIdentifier();
            $recordNote->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            $recordNote->meeting_date = date('Y-m-d', strtotime($mPostData['meeting_date']));

            $evidence = $this->request->getData()['attachment'];

            if ($evidence->getClientFileName()) {

//                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];

                $path = WWW_ROOT . 'img' . DS . 'record_notes' . DS . $new_name;
                $evidence->moveTo($path);
                $recordNote->attachment = $new_name;
            } else {
                $recordNote->attachment = NULL;
            }

            if ($result = $this->RecordNotes->save($recordNote)) {
                $get_overall_status = $this->saveRCD($result->id, $mPostData['decision_made'], $mPostData['completed'], $mPostData['timeline_label'], $mPostData['notes'], $mPostData['responsibility'], $mPostData['respons_depts'], $recordNote->meeting_date);
//                exit;
                $recordNote = $this->RecordNotes->get($result->id);
                $recordNote->overall_status = $get_overall_status;
                $this->RecordNotes->save($recordNote);
                $this->Flash->success(__('The record note has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
//            debug($recordNote);exit;
            $this->Flash->error(__('The record note could not be saved. Please, try again.'));
        }
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->set(compact('recordNote', 'departments'));
    }

    private function saveRCD($id = null, $decision = null, $completed = null, $timeline_label = null, $notes = null, $responsibility = null, $respons_depts = null, $meeting_date = null) {
        $main_status = [];
        foreach ($decision as $key => $data):
            switch ($timeline_label[$key]) {
                case 'immediate':
                    $timeline = date('Y-m-d', strtotime($meeting_date . '+2 day'));

                    break;
                case '1week':
                    $timeline = date('Y-m-d', strtotime($meeting_date . '+1 weeks'));


                    break;
                case '2week':
                    $timeline = date('Y-m-d', strtotime($meeting_date . '+2 weeks'));


                    break;
                case '3week':
                    $timeline = date('Y-m-d', strtotime($meeting_date . '+3 weeks'));


                    break;

                default: //1 Month
                    $timeline = date('Y-m-d', strtotime($meeting_date . '+1 month'));
                    break;
            }
//            debug($timeline);
//            exit;
            $status = ($completed[$key] == 'Yes') ? 2 : 9;
//                    debug($status);
            if ($status == 9) {
                $compare_date = $timeline;
                if ($compare_date >= $timeline) {
                    $status = 3;
                } else {
                    $now = time(); // or your date as well
                    $your_date = strtotime($timeline[$key]);
                    $datediff = $now - $your_date;

                    $diff = round($datediff / (60 * 60 * 24));
                    if ($diff > 15) { //danger zone
                        $status = 5;
                    } else { //off track
                        $status = 4;
                    }
                }
            }
            array_push($main_status, $status);

            $articles = $this->getTableLocator()->get('RecordNoteDetails');
            $data = [['record_note_id' => $id,
            'decision_made' => $data,
            'completed' => $completed[$key],
            'timeline_label' => $timeline_label[$key],
            'timeline' => $timeline,
            'notes' => $notes[$key],
            'responsibility' => $responsibility[$key],
            'respons_depts' => implode(',', $respons_depts[$key]),
            'status' => $status,
            'created' => date('Y-m-d')]];
//            debug($data);
//            exit;
            $entities = $articles->newEntities($data);
            $articles->saveMany($entities);

//record_note_id	decision_made	completed	timeline_label	timeline	notes	responsibility	respons_depts	status	created 
        endforeach;
        return max($main_status);
    }

    /**
     * Edit method
     *
     * @param string|null $id Record Note id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $recordNote = $this->RecordNotes->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mPostData = $this->request->getData();

            $recordNote = $this->RecordNotes->patchEntity($recordNote, $this->request->getData());
            $recordNote->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            $recordNote->meeting_date = date('Y-m-d', strtotime($mPostData['meeting_date']));

            $evidence = $this->request->getData()['attachment'];

            if ($evidence->getClientFileName()) {

//                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];

                $path = WWW_ROOT . 'img' . DS . 'record_notes' . DS . $new_name;
                $evidence->moveTo($path);
                $recordNote->attachment = $new_name;
            }

            if ($this->RecordNotes->save($recordNote)) {
                $this->Flash->success(__('The record note has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The record note could not be saved. Please, try again.'));
        }
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->set(compact('recordNote', 'departments'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Record Note id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $recordNote = $this->RecordNotes->get($id);
        if ($this->RecordNotes->delete($recordNote)) {
            $this->Flash->success(__('The record note has been deleted.'));
        } else {
            $this->Flash->error(__('The record note could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function finish_attachment($id = null) {
        $departmentScheme = $this->RecordNotes->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'record_notes' . DS . $departmentScheme->attachment);

        $departmentScheme->attachment = NULL;
        if ($this->RecordNotes->save($departmentScheme)) {
            $this->Flash->success(__('Attachment has been removed.'));

            return $this->redirect(['action' => 'edit', $id]);
        }
    }

}
