<?php

declare(strict_types = 1);

namespace App\Controller;

/**
 * CustomMilestones Controller
 *
 * @property \App\Model\Table\CustomMilestonesTable $CustomMilestones
 * @method \App\Model\Entity\CustomMilestone[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class CustomMilestonesController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        $this->Authentication->addUnauthenticatedActions(['remove']);
    }

    public function remove() {
//        debug($_GET);
        $customMilestone = $this->CustomMilestones->get($_GET['id']);
        $this->CustomMilestones->delete($customMilestone);
        echo json_encode('yes');
        exit;
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $this->paginate = [
            'contain' => ['DepartmentSchemes'],
        ];
        $customMilestones = $this->paginate($this->CustomMilestones);

        $this->set(compact('customMilestones'));
    }

    /**
     * View method
     *
     * @param string|null $id Custom Milestone id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $customMilestone = $this->CustomMilestones->get($id, [
            'contain' => ['DepartmentSchemes'],
        ]);

        $this->set(compact('customMilestone'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $customMilestone = $this->CustomMilestones->newEmptyEntity();
        if ($this->request->is('post')) {
            $customMilestone = $this->CustomMilestones->patchEntity($customMilestone, $this->request->getData());
            if ($this->CustomMilestones->save($customMilestone)) {
                $this->Flash->success(__('The custom milestone has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The custom milestone could not be saved. Please, try again.'));
        }
        $departmentSchemes = $this->CustomMilestones->DepartmentSchemes->find('list', ['limit' => 200]);
        $this->set(compact('customMilestone', 'departmentSchemes'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Custom Milestone id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $customMilestone = $this->CustomMilestones->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $customMilestone = $this->CustomMilestones->patchEntity($customMilestone, $this->request->getData());
            if ($this->CustomMilestones->save($customMilestone)) {
                $this->Flash->success(__('The custom milestone has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The custom milestone could not be saved. Please, try again.'));
        }
        $departmentSchemes = $this->CustomMilestones->DepartmentSchemes->find('list', ['limit' => 200]);
        $this->set(compact('customMilestone', 'departmentSchemes'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Custom Milestone id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $customMilestone = $this->CustomMilestones->get($id);
        if ($this->CustomMilestones->delete($customMilestone)) {
            $this->Flash->success(__('The custom milestone has been deleted.'));
        } else {
            $this->Flash->error(__('The custom milestone could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
