<?php

declare(strict_types = 1);

namespace App\Controller;

use App\Controller\AppController;
use Cake\Mailer\Email;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        $this->Authentication->addUnauthenticatedActions(['forgot', 'reset']);

        if ($this->Authentication->getResult()->getData() && $this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            if (!in_array($this->getRequest()->getParam('action'), ['login', 'view', 'edit', 'logout'])) {
//                debug($this->getRequest()->getParam('action'));exit;
                $this->Flash->error(__('You are not allowed to access that location.'));
                $this->redirect(['controller' => 'Users', 'action' => 'view']);
            }
        }
    }

    public function dashboard() {

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();

        $this->loadModel('DepartmentSchemes');
        $schemes = $this->DepartmentSchemes->find('all', ['conditions' => ['deleted' => 0, 'department_id' => $this->Authentication->getResult()->getData()->department_id]])->all();

        $this->loadModel('AttachedFormations');
        $attach_formations = $this->AttachedFormations->find('all', ['conditions' => ['department_id' => $this->Authentication->getResult()->getData()->department_id], 'contain' => ['DepartmentSchemes']])->all();
//        debug($attach_formations);exit;

        $this->set(compact(['usersRoles', 'schemes', 'attach_formations']));
    }

    public function forgot() {
        //$this->viewBuilder()->layout('client');
        $this->loadModel('Requests');
        $request = $this->Requests->newEmptyEntity();

        if ($this->request->is('post')) {
//            debug($this->request->getData());
//            exit;
            $count = $this->Users->find('all', array('conditions' => array('email' => $this->request->getData()['email'])))->first();
//            exit;
//            debug();exit;
            if ($count) {
//                debug($count);
//                exit;
                $Req['created'] = date('Y-m-d');
                $Req['ip'] = $this->request->clientIp();
                $Req['request'] = base64_encode($count['id'] . "," . $count['email'] . "," . date("Y-m-d") . "," . $this->request->clientIp());
                $Req['username'] = $count['email'];
//                debug($Req);exit;
                $request = $this->Requests->patchEntity($request, $Req);
//                debug($request);
                if ($this->Requests->save($request)) {
                    //send email setTo user
                    $this->send_email_forgot_password_link($count, $Req);
                    // return $this->redirect(array('controller' => 'Users', 'action' => 'forgot', 'success'));
                    return $this->redirect(array('controller' => 'Users', 'action' => 'forgot', 'success'));
                } else {

                    $this->Flash->error(__('The request could not be saved. Please, try again.'));
                }
            } else {
                $this->set('error', 'Wrong Email address given');
            }
        }
        $this->viewBuilder()->setLayout('default-login');
    }

    private function send_email_forgot_password_link($count = null, $data = null) {
        //email code starts here
        $email = new Email();
        $email->viewBuilder()->setTemplate('forgot_front', 'default');
        $email->setEmailFormat('html')
                ->setTo($this->request->getData()['email'])
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
                ->setBcc('info@cmdu.kp.gov.pk')
                //->from($this->request->getData()['email'])
                ->setSubject('cmdu.kp.gov.pk - Forgot Password Request')
                ->setViewVars(['userdata' => $count, 'request' => $data])
                ->send();

        //sms starts
        $message = 'Dear ' . ucwords($count['fname'] . ' ' . $count['lname']) . ', we got your request to change the password,'
                . ' you can change that by clicking the link: '
                . ' http://' . $_SERVER['SERVER_NAME'] . $this->request->getAttribute("webroot") . 'users/reset/' . $data['request'];
        $this->loadComponent('Sms');
        $this->Sms->sms(str_replace(' ', '', $count['tel1']), $message);
//        echo $response;
        //sms ends
    }

    public function reset($id = null) {
        //$this->viewBuilder()->layout('client');
        $findfields = explode(',', base64_decode($id));
//        debug($findfields);
        $this->loadModel('Requests');
        $count = $this->Requests->find('all', array('conditions' => array('username' => $findfields[1], 'ip' => $findfields[3])))->first();
//        debug($count);exit;
        if (!$this->Users->exists($findfields[0])) {
            throw new NotFoundException(__('Invalid User'));
        }

        if ($count) {
            $nowtime = date("Y-m-d");
            $requestedtime = $findfields[2];
//            debug($nowtime);
//            debug($requestedtime);exit;
            $date1 = date_create($nowtime);
            $date2 = date_create($requestedtime);
            $diff = date_diff($date1, $date2);

            if ($diff->format("%a") == 0) {
                $this->set('change', 'change');
            }
        } else {
            $this->set('error', 'error');
        }

        if ($this->request->is('post')) {
//            debug($this->request->getData());exit;
            $user = $this->Users->get($findfields[0], [
                'contain' => []
            ]);
            //debug($user);exit;
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user)) {
                $this->Requests->deleteAll(array('Request.username' => $findfields[1]), false);
                //  echo "454";exit;
                $this->Flash->success(__('Your profile has been updated.'));
                return $this->redirect(array('controller' => 'Users', 'action' => 'login'));
            } else {
                $this->Flash->error(__('Unable setTo update the password, try again'));
            }

            //return $this->redirect(array('controller' => 'Users', 'action' => 'login'));
        }
        $this->viewBuilder()->setLayout('default-login');
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index($attached_formation_id = null) {
        $cond = array();
        $cond[] = ['Users.deleted' => 0];
        $cond[] = ['Users.department_id' => $this->Authentication->getResult()->getData()->department_id];
        $cond[] = ['Users.users_roles_id' => 'pm'];

        if ($attached_formation_id) {
            $cond[] = ['Users.attached_formation_id' => $attached_formation_id];
        }

//debug($cond);exit;


        $this->paginate = [
            'contain' => ['AttachedFormations'],
            'conditions' => $cond
        ];
        $users = $this->paginate($this->Users);

        $this->set(compact('users'));
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
        $this->Authentication->addUnauthenticatedActions(['login']);
    }

    public function login() {

        $this->viewBuilder()->setLayout('default-login');

        $this->request->allowMethod(['get', 'post']);
        $result = $this->Authentication->getResult();
        // regardless of POST or GET, redirect if user is logged in
        if ($result->isValid()) {
//            debug($result->getData()->users_roles_id);exit;
            if ($result->getData()->users_roles_id == 'admin' || $result->getData()->users_roles_id == 'chief') {
                $this->Authentication->logout();
                $this->Flash->error(__('You are not allowed to login as CPO or PM, please contact CMDU'));
            } else {

                if ($result->getData()->locked || $result->getData()->deleted) {
                    $this->Authentication->logout();
                    $this->Flash->error(__('You are either locked or deleted by concerned department, please contact them.'));
                } else {
                    // redirect to /articles after login success
//                debug($this->Authentication->getLoginRedirect());exit;
                    if ($result->getData()->users_roles_id == 'cpo') {
                        $redirect = $this->Authentication->getLoginRedirect() ?? '/Users/dashboard';
                    } else {
                        $redirect = $this->Authentication->getLoginRedirect() ?? '/DepartmentSchemes/index';
                    }

//                    debug($redirect);exit;
//                $redirect = $this->request->getQuery('redirect', [
//                    'controller' => 'DepartmentSchemes',
//                    'action' => 'index',
//                ]);

                    return $this->redirect($redirect);
                }
            }
        }
//        debug($result);
        // display error if user submitted and authentication failed
        if ($this->request->is('post') && !$result->isValid()) {
            $this->Flash->error(__('Invalid email or password'));
        }
//    debug($result);
    }

// in src/Controller/UsersController.php
    public function logout() {
        $result = $this->Authentication->getResult();
        // regardless of POST or GET, redirect if user is logged in
        if ($result->isValid()) {
            $this->Authentication->logout();
            return $this->redirect(['controller' => 'Users', 'action' => 'login']);
        }
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        if ($id == null) {
            $id = $this->request->getAttribute('identity')->getIdentifier();
        }
        $user = $this->Users->get($id, [
            'contain' => ['UsersRoles', 'AttachedFormations'],
        ]);

        $this->set(compact('user'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add($dept_id = null) {


        $user = $this->Users->newEmptyEntity();
        if ($this->request->is('post')) {
            $mPostData = $this->request->getData();
//            debug($mPostData['avatar']);
//            exit;
            $mValidated = true;

            if ($mPostData['password_new'] == '') {
                $this->Flash->error(__('No password supplied.  Password is required.'));
                $mValidated = false;
            }
            if ($mPostData['password_conf'] == '') {
                $this->Flash->error(__('No password confirmation supplied.  Password confirmation is required.'));
                $mValidated = false;
            }
            if ($mPostData['password_new'] <> $mPostData['password_conf']) {
                $this->Flash->error(__('Password and password confirmation do not match.  Please enter a valid password and confirm it.'));
                $mValidated = false;
            }


            unset($mPostData['avatar']);
            $mPostData['password'] = $mPostData['password_new'];
            $user = $this->Users->patchEntity($user, $mPostData);

            if ($this->request->getData()['avatar']->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $this->request->getData()['avatar']->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array(end($img_ext), $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'users' . DS . $new_name;
                    $image = $this->request->getData()['avatar'];
                    $image->moveTo($path);
                    $user->avatar = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                $user->avatar = '';
            }
            if ($mValidated == true) {
                $user->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $user->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                $user->users_roles_id = 'pm';
                $user->department_id = $this->Authentication->getResult()->getData()->department_id;

                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The project manager has been saved.'));

                    if ($dept_id) {
                        return $this->redirect(['action' => 'index', $dept_id]);
                    }

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $this->loadModel('AttachedFormations');
        $attached_formations = $this->Users->AttachedFormations->find('list', ['conditions' => ['department_id' => $this->Authentication->getResult()->getData()->department_id], 'limit' => 200]);
        $usersRoles = $this->Users->UsersRoles->find('list', ['limit' => 200]);

        $this->set(compact('user', 'usersRoles', 'attached_formations'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $user = $this->Users->get($this->request->getAttribute('identity')->getIdentifier(), [
                'contain' => ['Departments'],
            ]);
        } else {
            $user = $this->Users->get($id, [
                'contain' => ['Departments'],
            ]);
        }

        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

            if ($mPostData['password_new'] <> '') {

                if ($mPostData['password_conf'] <> $mPostData['password_new']) {
                    $this->Flash->error(__('Password confirmation does not match new password.'));
                    $mValidated = false;
                } else {
                    //password & conf match
                    $mPostData['password'] = $mPostData['password_new'];
                }
            }
            unset($mPostData['avatar']);

            $user = $this->Users->patchEntity($user, $mPostData);
//            debug($this->request->getData());
//            exit;
            $image = $this->request->getData()['avatar'];

            if ($image->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $image->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array(end($img_ext), $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'users' . DS . $new_name;
                    $image->moveTo($path);
                    $user->avatar = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($user->avatar);
            }
//            debug($user);
//            exit;
            if ($mValidated == true) {
                $user->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The user has been saved.'));

                    return $this->redirect(['action' => 'view', $id]);
                }
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $this->loadModel('AttachedFormations');
        $attached_formations = $this->Users->AttachedFormations->find('list', ['conditions' => ['department_id' => $this->Authentication->getResult()->getData()->department_id], 'limit' => 200]);
        $usersRoles = $this->Users->UsersRoles->find('list', ['limit' => 200]);

        $this->set(compact('user', 'usersRoles', 'attached_formations'));
    }

    public function remove($id = null) {
        $departmentScheme = $this->Users->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'users' . DS . $departmentScheme->avatar);
        $departmentScheme->avatar = '';
        if ($this->Users->save($departmentScheme)) {

            $this->Flash->success(__('Avatar has been removed.'));

            return $this->redirect(['action' => 'edit', $id]);
        }
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);

        $dept_id = $user->department_id;

//        if ($this->Users->delete($user)) {

        $mUserData['email'] = 'deleted_' . date('YmdHis', time()) . $user['email'];
        $mUserData['deleted'] = '1';
        $mUserData['locked'] = '1';
        //$mUserData['password'] = 'deleted_'. $user['password'];

        $user = $this->Users->patchEntity($user, $mUserData);
        if ($this->Users->save($user)) {

            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }
        if ($dept_id) {
            return $this->redirect(['action' => 'index', $dept_id]);
        }

        return $this->redirect(['action' => 'index']);
    }

}
