<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SchemeStatus Entity
 *
 * @property int $id
 * @property string $status_name
 * @property string $status_color_pattern
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 * @property int $created_by
 * @property int $modified_by
 * @property bool $deleted
 *
 * @property \App\Model\Entity\DepartmentScheme[] $department_schemes
 */
class SchemeStatus extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'status_name' => true,
        'status_color_pattern' => true,
        'created' => true,
        'modified' => true,
        'created_by' => true,
        'modified_by' => true,
        'deleted' => true,
        'department_schemes' => true,
    ];
}
