<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SubActivity Entity
 *
 * @property int $id
 * @property string $activity
 * @property string|null $title
 * @property string|null $start_date
 * @property string|null $end_date 
 * @property string|null $responsibility
 * @property string|null $remarks 
 * @property string $active
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 * @property int $created_by
 * @property int $modified_by
 * @property bool $deleted
 *
 * @property \App\Model\Entity\SubActivityScheme[] $department_schemes
 * @property \App\Model\Entity\User[] $users
 * @property \App\Model\Entity\SchemeDistrict[] $scheme_districts
 */
class SubActivity extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'activity' => true,
        'title' => true,
        'department_scheme_id' => true,
        'start_date' => true,
        'end_date' => true,
        'responsibility' => true,
        'remarks' => true,
        'active' => true,
        'created' => true,
        'modified' => true,
        'created_by' => true,
        'modified_by' => true,
        'deleted' => true,
    ];
}
