<?php

declare(strict_types = 1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Users Model
 *
 * @property \App\Model\Table\UsersRolesTable&\Cake\ORM\Association\BelongsTo $UsersRoles
 *
 * @method \App\Model\Entity\User newEmptyEntity()
 * @method \App\Model\Entity\User newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\User[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\User get($primaryKey, $options = [])
 * @method \App\Model\Entity\User findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\User patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\User[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\User|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\User saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class UsersTable extends Table {

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void {
        parent::initialize($config);

        $this->setTable('users');
        $this->setDisplayField('full_name');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('UsersRoles', [
            'foreignKey' => 'users_roles_id',
            'joinType' => 'INNER',
        ]);
        
        $this->belongsTo('Departments', [
            'foreignKey' => 'department_id',
            'joinType' => 'LEFT',
        ]);
          
        $this->belongsTo('AttachedFormations', [
            'foreignKey' => 'attached_formation_id',
            'joinType' => 'LEFT',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator {
        $validator
                ->integer('id')
                ->allowEmptyString('id', null, 'create');

        $validator
                ->scalar('fname')
                ->maxLength('fname', 55)
                ->allowEmptyString('fname');

        $validator
                ->scalar('lname')
                ->maxLength('lname', 55)
                ->allowEmptyString('lname');

        $validator
                ->email('email')
                ->maxLength('email', 150)
                ->requirePresence('email', 'create')
                ->notEmptyString('email');

        $validator
                ->scalar('password')
                ->maxLength('password', 255)
                ->requirePresence('password', 'create')
                ->notEmptyString('password');
        
         $validator
                ->scalar('users_roles_id')
                ->maxLength('users_roles_id', 255)
                ->requirePresence('users_roles_id', 'create')
                ->notEmptyString('users_roles_id');

//        $validator
//                ->integer('locked')
//                ->notEmptyString('locked');

        $validator
                ->integer('active')
                ->allowEmptyString('active');

//        $validator
//                ->scalar('avatar')
//                ->maxLength('avatar', 75)
//                ->allowEmptyString('avatar');

        $validator
                ->scalar('tel1')
                ->maxLength('tel1', 55)
                ->allowEmptyString('tel1');

        $validator
                ->scalar('tel2')
                ->maxLength('tel2', 55)
                ->allowEmptyString('tel2');

        $validator
                ->scalar('fax')
                ->maxLength('fax', 55)
                ->allowEmptyString('fax');

        $validator
                ->scalar('addr1')
                ->maxLength('addr1', 55)
                ->allowEmptyString('addr1');

        $validator
                ->scalar('addr2')
                ->maxLength('addr2', 55)
                ->allowEmptyString('addr2');

        $validator
                ->scalar('city')
                ->maxLength('city', 22)
                ->allowEmptyString('city');

        $validator
                ->scalar('state')
                ->maxLength('state', 2)
                ->allowEmptyString('state');

        $validator
                ->scalar('postal')
                ->maxLength('postal', 15)
                ->allowEmptyString('postal');

        $validator
                ->scalar('country')
                ->maxLength('country', 5)
                ->allowEmptyString('country');

        $validator
                ->scalar('comments')
                ->allowEmptyString('comments');

        $validator
                ->integer('login_failures')
                ->allowEmptyString('login_failures');

        $validator
                ->dateTime('last_login_failure')
                ->allowEmptyDateTime('last_login_failure');

        $validator
                ->dateTime('last_login_success')
                ->allowEmptyDateTime('last_login_success');

        $validator
                ->integer('created_by')
                ->requirePresence('created_by', 'create')
                ->notEmptyString('created_by');

        $validator
                ->integer('modified_by')
                ->requirePresence('modified_by', 'create')
                ->notEmptyString('modified_by');

        $validator
                ->integer('deleted')
                ->allowEmptyString('deleted');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker {
        $rules->add($rules->isUnique(['email']), ['errorField' => 'email']);
        $rules->add($rules->existsIn(['users_roles_id'], 'UsersRoles'), ['errorField' => 'users_roles_id']);

        return $rules;
    }

}
