<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\AssignChiefDepartment[]|\Cake\Collection\CollectionInterface $assignChiefDepartments
 */
$this->assign('title', 'Listing Chief Departments');

use Cake\ORM\TableRegistry;
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i>  Assign New Department to Chief'), ['action' => 'add'], ['escape' => false]) ?></li>

        <!--<li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>-->
<!--                        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
                            <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Listing Chief Departments') ?></h3>
        </header>

        <div class="assignChiefDepartments card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= __('id') ?></th>-->
                        <th scope="col"><?= __('Chief') ?></th>
                        <th scope="col"><?= __('department(s)') ?></th>
                        <th scope="col"><?= __('created') ?></th>
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $SchemeDistricts = TableRegistry::get('AssignChiefDepartments');

                    foreach ($assignChiefDepartments as $assignChiefDepartment):
                        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['AssignChiefDepartments.user_id' => $assignChiefDepartment->user_id]])->all();
                        ?>
                        <tr>
                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($assignChiefDepartment->id) ?></td>-->
                            <td><?= $assignChiefDepartment->has('user') ? $this->Html->link(ucwords($assignChiefDepartment->user->fname . ' ' . $assignChiefDepartment->user->lname), ['controller' => 'Users', 'action' => 'view', $assignChiefDepartment->user->id]) : '' ?></td>
                            <td><?php
                                $dept_array = array();
                                foreach ($choosen_nav_districts as $dis):
                                    if (isset($departments[$dis->department_id])) {
                                        array_push($dept_array, $departments[$dis->department_id]);
                                    }
                                endforeach;
                                echo implode(', ', $dept_array);
                                ?></td>

                            <td class="text-left" data-title="Created"><?= h($assignChiefDepartment->created) ?></td>
                            <td class="actions">
                                <?php $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $assignChiefDepartment->user_id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $assignChiefDepartment->user_id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $assignChiefDepartment->user_id], ['confirm' => __('Are you sure you want to delete?'), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

        </div>
    </section>
</div><!--/row-->
