<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Comment $comment
 */
$this->assign('title', 'Viewing Comment');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Comment'), ['action' => 'edit', $comment->id], ['escape' => false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Comment'), ['action' => 'delete', $comment->id], ['confirm' => __('Are you sure you want to delete # {0}?', $comment->id), 'escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Comments'), ['action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Comment'), ['action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?> </li>
    </ul>
</nav>
<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Comments</h2>
        </header>

        <div class="comments card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <tr>
                    <th scope="row"><?= __('User') ?></th>
                    <td><?= $comment->has('user') ? $this->Html->link($comment->user->full_name, ['controller' => 'Users', 'action' => 'view', $comment->user->id]) : '' ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Department') ?></th>
                    <td><?= $comment->has('department') ? $this->Html->link($comment->department->department_name, ['controller' => 'Departments', 'action' => 'view', $comment->department->id]) : '' ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Department Scheme') ?></th>
                    <td><?= $comment->has('department_scheme') ? $this->Html->link($comment->department_scheme->id, ['controller' => 'DepartmentSchemes', 'action' => 'view', $comment->department_scheme->id]) : '' ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Id') ?></th>
                    <td><?= $this->Number->format($comment->id) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Created') ?></th>
                    <td><?= h($comment->created) ?></td>
                </tr>
            </table>
            <div class="row">
                <h4><?= __('Comments') ?></h4>

                <?= $this->Text->autoParagraph(h($comment->comments)); ?>

            </div>
        </div><!--/content-->
    </section>
</div><!--/row-->
