<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\DepartmentScheme[]|\Cake\Collection\CollectionInterface $departmentSchemes
*/
$this->assign('title', 'Listing Department Schemes');
?>

        <nav class="large-3 medium-4 columns" id="actions-sidebar">
        <ul class="side-nav">
            <li class="heading"><?= __('Actions') ?></li>
                    <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['action' => 'add'], ['escape'=>false]) ?></li>

                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                                        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                                                                            <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                </ul>
    </nav>

    <div class="row">
        <section class="card">


            <header class="card-header">
                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>
                <h3><?= __('Department Schemes') ?></h3>
            </header>

            <div class="departmentSchemes card-body content">

                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                    <thead>
                        <tr>
                                                            <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('department_id') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('scheme_status_id') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('scheme_name') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('active') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('directive') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('cost_of_scheme') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('expenditure_till_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('allocation_for_cfy') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('release_for_cfy') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('geo_coverage') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('scheme_start_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('scheme_end_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc2_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc2_approved') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('consultant_hired') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('cons_subt_report') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc2_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('responsible_pc2_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc1_approved') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc1_approval_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc1_stage') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc1_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('pc1_responsible') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('sne_approved') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_through_psc') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_compl_date_psc') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('responsible_psc') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_through_internal_posting') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_compl_date_internal_posting') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('responsible_internal_posting') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_through_market') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('posting_though_market_media') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_entries_recorded') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_scrutiny_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_intervies_cond') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_appoint_letter_issues') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('hiring_market_respons_person') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_acquisition_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_identified') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_section4_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_section6_comp') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_possision_taken_over') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_award_been_issued') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_payment_made') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_acquisition_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('land_acquisition_responsible') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_tender_advertised') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_bidding_complete') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_po_issued') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_delivery_physical_verification_done') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_distribution_equipments') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_evidence_of_distribution') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_goods_responsible') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_tender_advertised') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_tech_finance_proposal_received') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_evaluation_process_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_contract_awarded') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_status') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('proc_services_responsible') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('cons_civil_work_required') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_carried_by_civil_works') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_commisioned_privately') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_tender_advertised') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_bidding_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_order_issued') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('is_work_begun') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('level_of_work_compl') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('cons_civil_compl_date') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('cons_civil_responsible') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('comments') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('scheme_file') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('deleted') ?></th>
                                                            <th scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($departmentSchemes as $departmentScheme): ?>
                        <tr>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <td class="text-right" data-title="Id"><?= $this->Number->format($departmentScheme->id) ?></td>
                                                                                                                                                                                                                                                                                                                                    <td><?= $departmentScheme->has('department') ? $this->Html->link($departmentScheme->department->id, ['controller' => 'Departments', 'action' => 'view', $departmentScheme->department->id]) : '' ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    <td><?= $departmentScheme->has('scheme_status') ? $this->Html->link($departmentScheme->scheme_status->id, ['controller' => 'SchemeStatuses', 'action' => 'view', $departmentScheme->scheme_status->id]) : '' ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    <td class="text-left" data-title="Scheme Name"><?= h($departmentScheme->scheme_name) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Active"><?= h($departmentScheme->active) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Directive"><?= h($departmentScheme->directive) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Cost Of Scheme"><?= $this->Number->format($departmentScheme->cost_of_scheme) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Expenditure Till Date"><?= $this->Number->format($departmentScheme->expenditure_till_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Allocation For Cfy"><?= $this->Number->format($departmentScheme->allocation_for_cfy) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Release For Cfy"><?= $this->Number->format($departmentScheme->release_for_cfy) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Geo Coverage"><?= h($departmentScheme->geo_coverage) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Scheme Start Date"><?= h($departmentScheme->scheme_start_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Scheme End Date"><?= h($departmentScheme->scheme_end_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc2 Required"><?= h($departmentScheme->pc2_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc2 Approved"><?= h($departmentScheme->pc2_approved) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Consultant Hired"><?= h($departmentScheme->consultant_hired) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Cons Subt Report"><?= h($departmentScheme->cons_subt_report) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc2 Compl Date"><?= h($departmentScheme->pc2_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Responsible Pc2 Compl"><?= h($departmentScheme->responsible_pc2_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc1 Approved"><?= h($departmentScheme->pc1_approved) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc1 Approval Date"><?= h($departmentScheme->pc1_approval_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc1 Stage"><?= h($departmentScheme->pc1_stage) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc1 Compl Date"><?= h($departmentScheme->pc1_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Pc1 Responsible"><?= h($departmentScheme->pc1_responsible) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Required"><?= h($departmentScheme->hiring_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Sne Approved"><?= h($departmentScheme->sne_approved) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Through Psc"><?= h($departmentScheme->hiring_through_psc) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Compl Date Psc"><?= h($departmentScheme->hiring_compl_date_psc) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Responsible Psc"><?= h($departmentScheme->responsible_psc) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Through Internal Posting"><?= h($departmentScheme->hiring_through_internal_posting) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Compl Date Internal Posting"><?= h($departmentScheme->hiring_compl_date_internal_posting) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Responsible Internal Posting"><?= h($departmentScheme->responsible_internal_posting) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Through Market"><?= h($departmentScheme->hiring_through_market) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Posting Though Market Media"><?= h($departmentScheme->posting_though_market_media) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Entries Recorded"><?= h($departmentScheme->hiring_market_entries_recorded) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Scrutiny Compl"><?= h($departmentScheme->hiring_market_scrutiny_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Intervies Cond"><?= h($departmentScheme->hiring_market_intervies_cond) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Appoint Letter Issues"><?= h($departmentScheme->hiring_market_appoint_letter_issues) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Compl Date"><?= h($departmentScheme->hiring_market_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Hiring Market Respons Person"><?= h($departmentScheme->hiring_market_respons_person) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Acquisition Required"><?= h($departmentScheme->land_acquisition_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Identified"><?= h($departmentScheme->land_identified) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Section4 Compl"><?= h($departmentScheme->land_section4_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Section6 Comp"><?= h($departmentScheme->land_section6_comp) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Possision Taken Over"><?= h($departmentScheme->land_possision_taken_over) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Award Been Issued"><?= h($departmentScheme->land_award_been_issued) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Payment Made"><?= h($departmentScheme->land_payment_made) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Acquisition Compl Date"><?= h($departmentScheme->land_acquisition_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Land Acquisition Responsible"><?= h($departmentScheme->land_acquisition_responsible) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Required"><?= h($departmentScheme->proc_goods_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Tender Advertised"><?= h($departmentScheme->proc_goods_tender_advertised) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Bidding Complete"><?= h($departmentScheme->proc_goods_bidding_complete) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Po Issued"><?= h($departmentScheme->proc_goods_po_issued) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Delivery Physical Verification Done"><?= h($departmentScheme->proc_goods_delivery_physical_verification_done) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Distribution Equipments"><?= h($departmentScheme->proc_goods_distribution_equipments) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Evidence Of Distribution"><?= h($departmentScheme->proc_goods_evidence_of_distribution) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Compl Date"><?= h($departmentScheme->proc_goods_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Goods Responsible"><?= h($departmentScheme->proc_goods_responsible) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Required"><?= h($departmentScheme->proc_services_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Tender Advertised"><?= h($departmentScheme->proc_services_tender_advertised) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Tech Finance Proposal Received"><?= h($departmentScheme->proc_services_tech_finance_proposal_received) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Evaluation Process Compl"><?= h($departmentScheme->proc_services_evaluation_process_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Contract Awarded"><?= h($departmentScheme->proc_services_contract_awarded) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Status"><?= h($departmentScheme->proc_services_status) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Compl Date"><?= h($departmentScheme->proc_services_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Proc Services Responsible"><?= h($departmentScheme->proc_services_responsible) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Cons Civil Work Required"><?= h($departmentScheme->cons_civil_work_required) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Carried By Civil Works"><?= h($departmentScheme->is_work_carried_by_civil_works) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Commisioned Privately"><?= h($departmentScheme->is_work_commisioned_privately) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Tender Advertised"><?= h($departmentScheme->is_work_tender_advertised) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Bidding Compl"><?= h($departmentScheme->is_work_bidding_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Order Issued"><?= h($departmentScheme->is_work_order_issued) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Is Work Begun"><?= h($departmentScheme->is_work_begun) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Level Of Work Compl"><?= h($departmentScheme->level_of_work_compl) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Cons Civil Compl Date"><?= h($departmentScheme->cons_civil_compl_date) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Cons Civil Responsible"><?= h($departmentScheme->cons_civil_responsible) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Comments"><?= h($departmentScheme->comments) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Scheme File"><?= h($departmentScheme->scheme_file) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Created"><?= h($departmentScheme->created) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Modified"><?= h($departmentScheme->modified) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Created By"><?= $this->Number->format($departmentScheme->created_by) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Modified By"><?= $this->Number->format($departmentScheme->modified_by) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-left" data-title="Deleted"><?= h($departmentScheme->deleted) ?></td>
                                                                                                                                                        <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $departmentScheme->id], ['escape'=>false] ) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $departmentScheme->id], ['escape'=>false] )  ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $departmentScheme->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <footer class="card-footer text-right">
                    <div class="paginator">
                        <ul class="pagination">
                            <?= $this->Paginator->first('<< ' . __('first')) ?>
                            <?= $this->Paginator->prev('< ' . __('previous')) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next(__('next') . ' >') ?>
                            <?= $this->Paginator->last(__('last') . ' >>') ?>
                        </ul>
                        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                    </div>
                </footer>
            </div>
        </section>
    </div><!--/row-->
