<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is procurement of goods required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q5" style="display:<?= ($departmentScheme->proc_goods_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                        <?php
                        $required = ($departmentScheme->proc_goods_required == 'Yes') ? 'required' : '';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the tender been advertised?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_tender_advertised', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the bidding and selection process complete?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_bidding_complete', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Have the purchase orders been issued?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_po_issued', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has delivery/physical verification of goods been done?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_delivery_physical_verification_done', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the distribution of equipment been done?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_distribution_equipments', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Please attach supporting notification/photographic evidence/ letter (if applicable)') . '</label></div>';

                        echo '<div class="col-sm-7">';
//                        debug($departmentScheme->proc_goods_evidence_of_distribution);
                        if (file_exists(WWW_ROOT . 'img/scheme_files/' . $departmentScheme->proc_goods_evidence_of_distribution) && !empty($departmentScheme->proc_goods_evidence_of_distribution)) {

                            echo '<strong>Existing Evidence: </strong><img src="' . $this->request->getAttribute("webroot") . 'img/scheme_files/' . $departmentScheme->proc_goods_evidence_of_distribution . '" style="max-height:100px">';
                            echo '&nbsp;&nbsp;<a id="delete_evidence" style="color:red;" href="#"><i aria-hidden="true" class="fas fa-trash"></i></a>';
                        }
                        echo $this->Form->control('proc_goods_evidence_of_distribution', ['class' => 'form-control', 'label' => false, 'type' => 'file']);
                        echo '</div>';

                        echo '</div><!--/row-->';

//                        echo $this->Form->hidden('proc_goods_old_compl_date', ['id' => 'proc_goods_old_compl_date', 'value' => date('Y-m-d', strtotime($departmentScheme->proc_goods_compl_date))]);

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the completion date for procurement of goods?') . '</label></div>';
                        echo '<div class="col-sm-7">';
                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_goods_compl_date && !in_array($myUser->users_roles_id, ['admin', 'sub-admin'])) {
                            if ($myUser->users_roles_id == 'pm') { //cant do anything
                                //display old date
                                echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_goods_compl_date));
                            } else { //cpo
                                //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                    //cpo cant do anything too-display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_goods_compl_date));
                                } else {
                                    //cpo can do and show fields again
                                    echo $this->Form->control('proc_goods_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_goods_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_goods_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
                            }
                        } else {
                            //show fields to change
                            echo $this->Form->control('proc_goods_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_goods_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_goods_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                        }

//                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_goods_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_goods_compl_date));
//                        } else {
//                            echo $this->Form->control('proc_goods_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_goods_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_goods_compl_date)) : '']);
//                        }
                        echo '</div>';
                        echo '</div><!--/row-->';
                        $departments['Other'] = 'Other';
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the procurement of goods?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_goods_responsible', ['class' => 'form-control', 'label' => false, $required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('designation_step5', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                        echo '</div><!--/row-->';

                        echo $this->Form->control('step5_old_remarks', ['value' => $departmentScheme->step5_remarks, 'type' => 'hidden']);

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label><br/><small>(You can add your weekly updates here in this section too). </small></div>';

                        echo '<div class="col-sm-7">' . $this->Form->control('step5_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step4/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';       ?>
                    <?php
//                    if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_goods_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
//                        if ($schemeRequests == 0) {
                    ?>
                    <!--<a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the procurement of goods Process?</a>-->
                    <?php
//                        } else {
//                            echo "Request already pending to change date.";
//                        }
//                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {

//q5
        $('body').on('change', '#proc-goods-required', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q5').show('slow');
                $('#q5').find('input').attr('required', true);
                $('#q5').find('select').attr('required', true);
                $('#proc-goods-evidence-of-distribution').attr('required', false);
                $('#proc-goods-responsible').val(<?= $departmentScheme->department_id ?>);
            } else {
                $('#q5').find('input').attr('required', false);
                $('#q5').find('select').attr('required', false);
                $('#q5').find('input').val('');
                $('#q5').find('select').val('');

                $('#q5').hide('slow');
            }
            $('#designation-step5').attr('required', false);

        });

        $('body').on('click', '#delete_evidence', function () {
            if (confirm('Are you sure want to delete?')) {
                window.location.href = '<?php echo $this->request->getAttribute("webroot"); ?>admin/DepartmentSchemes/remove_step5_evidence/<?php echo $departmentScheme->id; ?>';
                            }
                        });

//                        $('body').on('change', '#proc-goods-compl-date', function () {
//
//                            if ($('#proc_goods_old_compl_date').val() !== '1970-01-01' && $('#proc_goods_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                                if ($(this).val() !== $('#proc_goods_old_compl_date').val()) {
//                                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                                }
//                            }
//                        });

                    });
</script>
