<style>
sup {
	font-size: x-small
}
.hide-row, .add-sub-activity {
	display:none;
}
</style>
<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */

use Cake\ORM\TableRegistry;
?>
<div class="row">
  <div class="col-sm-12 col-md-12">
    <section class="card">
      <header class="card-header">
        <h2 class="card-title">Delayed Schemes Viewer</h2>
      </header>
      <form action="" method="get" name="search" id="search-form" class="card-body">
        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered" >
          <thead>
            <tr>
            	<td><label for="scheme_name">Scheme Name</label><br><input type="text" name="scheme_name" id="scheme_name" value="<?php echo isset($_GET['scheme_name']) ? trim($_GET['scheme_name']) : ''?>" placeholder="Scheme Name..." class="form-control" /></td>
            	<td>
                	<label for="department">Department</label><br>
                	<select name="department" class="form-control" id="department">
					  <option value="All">All</option>
					  <?php foreach($departments as $key => $department){
                          //echo '<pre>';print_r($departments);exit;?>
                      <option value="<?php echo $key;?>" <?php echo isset($_GET['department']) && trim($_GET['department']) == $key ? 'selected' : ''?>><?php echo $department;?></option>
                      <?php }?>
                    </select>
                </td>
            	<td>
                	<label for="tl">TL</label><br>
                	<select name="tl" class="form-control" id="tl">
					  <option value="All">All</option>
                      <option value="2" <?php echo isset($_GET['department']) && trim($_GET['tl']) == 2 ? 'selected' : ''?>>Completed</option>
					  <option value="3" <?php echo isset($_GET['department']) && trim($_GET['tl']) == 3 ? 'selected' : ''?>>On Target</option>
					  <option value="4" <?php echo isset($_GET['department']) && trim($_GET['tl']) == 4 ? 'selected' : ''?>>Off Target</option>
					  <option value="5" <?php echo isset($_GET['department']) && trim($_GET['tl']) == 5 ? 'selected' : ''?>>Critically Delayed</option>
                    </select>
                </td>
                <td>
                	<label for="year">Due Year</label><br>
                	<select name="year" class="form-control" id="year">
					  <option value="Any">Any</option>
                      <?php for($i = 2000; $i <= date('Y') + 10; $i++){?>
                      <option <?php echo isset($_GET['year']) && trim($_GET['year']) == $i ? 'selected' : ''?>><?php echo $i;?></option>
                      <?php }?>
                    </select>
                </td>
                <?php /*?><td><label for="start_date">Start Date</label><br><input type="date" name="start_date" id="start_date" value="<?php echo isset($_GET['start_date']) ? trim($_GET['start_date']) : ''?>" class="form-control" /></td>
                <td><label for="end_date">End Date</label><br><input type="date" name="end_date" id="end_date" value="<?php echo isset($_GET['end_date']) ? trim($_GET['end_date']) : ''?>" class="form-control" /></td><?php */?>
                <td>
                	<label for="category">Category</label><br>
                	<select class="form-control" name="category" id="category">
                        <option value="All">All Categories</option>
                        <option value="Mega" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'Mega' ? 'selected' : ''?>>Mega Schemes</option>
                        <option value="Mega-high" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'Mega-high' ? 'selected' : ''?>>Mega &amp; High Priority Schemes</option>
                        <option value="High Priority" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'High Priority' ? 'selected' : ''?>>High Priority Schemes</option>
                        <option value="DFC (Two Years)" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'DFC (Two Years)' ? 'selected' : ''?>>DFC (Two Years)</option>
                        <option value="DFC (Current Year)" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'DFC (Current Year)' ? 'selected' : ''?>>DFC (Current Year)</option>
                        <option value="Normal" <?php echo isset($_GET['category']) && trim($_GET['category']) == 'Normal' ? 'selected' : ''?>>Normal Schemes</option>
                    </select>
                </td>
                <td>
                	<label for="type">Type</label><br>
                	<select class="form-control" name="type" id="type">
                        <option value="All" selected="selected">All Types</option>
                        <option value="ADP" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'ADP' ? 'selected' : ''?>>ADP</option>
                        <option value="MA-ADP" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'MA-ADP' ? 'selected' : ''?>>MA-ADP</option>
                        <option value="AIP" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'AIP' ? 'selected' : ''?>>AIP</option>
                        <option value="PSDP" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'PSDP' ? 'selected' : ''?>>PSDP</option>
                        <option value="Own_source" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'Own_source' ? 'selected' : ''?>>Own Source</option>
                        <option value="CPEC" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'CPEC' ? 'selected' : ''?>>CPEC</option>
                        <option value="Other" <?php echo isset($_GET['type']) && trim($_GET['type']) == 'Other' ? 'selected' : ''?>>Other</option>
                    </select>
                </td>
                <td colspan="2">
                	<button class="btn btn-primary" type="submit">Search</button><!--<br><br>-->
                    <a href="javascript:;" id="export-excel" class="btn btn-primary"><i class="fas fa-download"></i> Export Excel</a><!--<br><br>
                    <a href="javascript:;" id="export-pdf" class="btn btn-primary"><i class="fas fa-download"></i> Export PDF</a>-->
                </td>
            </tr>
          </thead>  
          <thead>
            <tr>
              <th width="15%">Scheme Code</th>
              <th width="20%">Scheme Name</th>
              <th width="15%">Department</th>
              <th width="10%">Start Date</th>
              <th width="10%">Deadline</th>
              <th width="10%">Scheme Type</th>
              <th width="10%">Updated At</th>
              <th width="10%">T/L</th>
            </tr>
          </thead>
          <tbody>
          	<?php foreach($DepartmentSchemes as $rec){
				//$img = $this->request->getAttribute("webroot").'img/milestones_status/'.$rec->status.'.PNG';?>            
            <tr>
              <td><a href="<?php echo $this->request->getAttribute("webroot").'admin/department_schemes/view/'.$rec->id;?>"><?php echo $rec->scheme_code;?></a></td>
              <td><a href="javascript:;" data-toggle="toggle" data-id="<?php echo 'activity-'.$rec->id; ?>"><?php echo $rec->scheme_name;?></a></td>
              <td><?php echo !empty($rec->d) ? $rec->d->department_name : 'N/A';?></td>
              <td><?php echo date('d M, Y', strtotime($rec->scheme_start_date));?></td>
              <td><?php echo date('d M, Y', strtotime($rec->scheme_end_date));?></td>
              <td><?php echo $rec->scheme_type;?></td>
              <?php /*?><td><?php echo $rec->scheme_type;?></td><?php */?>
              <td><?php echo date('d M, Y', strtotime($rec->modified));?></td>
              <td><img src="<?php echo $rec->scheme_status_img;?>" /></td>
            </tr>
            <?php if(!empty($rec->activities)){?>
            <tr class="hide-row <?php echo 'activity-'.$rec->id;?>">
            	<td colspan="7" style="padding-left:20px;">
                	<table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered">
                    	<thead>
                            <tr>
                              <th>Activity</th>
                              <th width="150">Start Date</th>
                              <th width="150">Deadline</th>
                              <th>Responsibility</th>
                              <th>Remarks</th>
                              <th>T/L</th>
                        	</tr>
                        </thead>
                    	<?php foreach($rec->activities as $activity){?>
                    	<tr>
                        	<td><a href="javascript:;" data-toggle="toggle" data-id="<?php echo 'sub-activity-'.$activity->id; ?>">
								<?php echo $activity->milestone_name;?>
								<?php if(trim($activity->type) != '---' && trim($activity->type) != ''){
									 echo ' <b>- '.$activity->type.'</b>';
								}
								if(trim($activity->district) != '---' && trim($activity->district) != ''){
									 echo ' <b>- '.$activity->district.'</b>';
								}?>    
                            	</a>
                            </td>
                        	<td><?php echo date('d M, Y', strtotime($activity->start_date));?></td>
                        	<td><?php echo date('d M, Y', strtotime($activity->completion_date));?></td>
                        	<td><?php echo $activity->responsibility;?></td>
                        	<td><?php echo $activity->remarks;?></td>
                        	<td><img src="<?php echo $activity->overall_status_img;?>" /></td>
                        </tr>
                        <?php if(!empty($activity->sub_activities)){?>
                        <tr class="hide-row <?php echo 'sub-activity-'.$activity->id;?>">
                            <td colspan="7" style="padding-left:20px;">
                                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered">
                                    <thead>
                                        <tr>
                                          <th>Sub-Activity</th>
                                          <th width="150">Start Date</th>
                                          <th width="150">Deadline</th>
                                          <th>Responsibility</th>
                                          <th>Remarks</th>
                                          <th>T/L</th>
                                        </tr>
                                    </thead>
                                    <?php foreach($activity->sub_activities as $sub_activity){?>
                                    <tr>
                                        <td><?php echo $sub_activity->title;?></td>
                                        <td><?php echo date('d M, Y', strtotime($sub_activity->start_date));?></td>
                                        <td><?php echo date('d M, Y', strtotime($sub_activity->end_date));?></td>
                                        <td><?php echo $sub_activity->responsibility;?></td>
                                        <td><?php echo $sub_activity->remarks;?></td>
                                        <td><img src="<?php echo $sub_activity->img;?>" /></td>
                                    </tr>
                                    <?php }?>
                                </table>
                            </td>
                        </tr>
                        <?php }?>
                        <?php }?>
                    </table>
                </td>
            </tr>
            <?php }?>
            <?php }?>
            <tr>
            	<td colspan="7">
                    <ul class="pagination">
                    <?= $this->Paginator->prev("<<") ?>
                    <?= $this->Paginator->numbers() ?>
                    <?= $this->Paginator->next(">>") ?>
                    </ul>
                </td>
            </tr>
          </tbody>
        </table>
      </form>
    </section>
  </div>
</div>
<script type="text/javascript">
$(document).ready(function () {
	$('.hide-row').slideUp(600);
	$('[data-toggle="toggle"]').click(function () {  
        var id = $(this).data('id'); 
		if ($(this).parents().next(".hide-row").is(':visible')) {
			//$(this).parents().next('.hide-row').slideUp(600);            
			$('.'+id).slideUp(600);
		}  
        else 
		{
			//$(this).parents().next('.hide-row').slideDown(600);
			$('.'+id).slideDown(600);
			window.dispatchEvent(new Event('resize'));
		}
    });  
	
	$('#export-excel').click(function(e) {
        var action = $('#search-form').attr('action');
		//console.log(action);
		$('#search-form').attr('action','<?php echo $this->request->getAttribute("webroot").'admin/department_schemes/sub_activities_excel';?>');
		//console.log($('#search-form').attr('action'));
		$('#search-form').submit();
		$('#search-form').attr('action',action);
    });
	
	$('#export-pdf').click(function(e) {
        var action = $('#search-form').attr('action');
		//console.log(action);
		$('#search-form').attr('action','<?php echo $this->request->getAttribute("webroot").'admin/department_schemes/sub_activities_pdf';?>');
		//console.log($('#search-form').attr('action'));
		$('#search-form').submit();
		$('#search-form').attr('action',action);
    });
	
});
</script>