<?php

use Cake\ORM\TableRegistry;

require_once(APP . 'Vendor' . DS . 'PHPExcel' . DS . 'PHPExcel.php');

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator($this->request->getSession()->read('Auth.User.username'));


$styleArray = array(
    'font' => array(
        'bold' => true,
    ),
//    'alignment' => array(
//        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
//    ),
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'left' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'right' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        )
    ),
//    'fill' => array(
//        'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
//        'rotation' => 90,
//        'startcolor' => array(
//            'argb' => 'FFA0A0A0',
//        ),
//        'endcolor' => array(
//            'argb' => 'FFFFFFFF',
//        ),
//    ),
);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
//$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
//
//

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);


//HEADER

$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Status');
$objPHPExcel->getActiveSheet()->setCellValue('B1', 'Code');
$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Scheme Name');
$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Scheme Type');
$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Department');
$objPHPExcel->getActiveSheet()->setCellValue('F1', 'Last Updated');
$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Issues');


$i = 2;

foreach ($departmentSchemes as $details):

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $details->overall_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('A' . $i);
    $objDrawing->setHeight(18); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $details->scheme_code);
    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, ucfirst($details->scheme_name));
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, ucfirst($details->scheme_type));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, ucfirst($departments[$details->department_id]));
    $objPHPExcel->getActiveSheet()->setCellValue('F' . $i, date('j F Y', strtotime($details->last_modified)));
    $objPHPExcel->getActiveSheet()->setCellValue('G' . $i, ucfirst(preg_replace('/[^\da-z ]/i', '', $details->issues_list)));


    $i++;
endforeach;



// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Tracker');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

//call the function in the controller with $output_type = F and $file with complete path to the file, to generate the file in the server for example attach to email
if (isset($output_type) && $output_type == 'F') {
    echo "132";
    exit;
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save($file);
} else {
//    echo "136";exit;
    // Redirect output to a client's web browser (Excel2007)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $file . '"');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save('php://output');
}