<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\Department $department
*/
$this->assign('title', 'Viewing Department');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Department'), ['action' => 'edit', $department->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Department'), ['action' => 'delete', $department->id], ['confirm' => __('Are you sure you want to delete # {0}?', $department->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                                                        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                        </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Departments</h2>
        </header>

    <div class="departments card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                        <tr>
                            <th scope="row"><?= __('Department Name') ?></th>
                            <td><?= h($department->department_name) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Department Logo') ?></th>
                            <td><?= h($department->department_logo) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Active') ?></th>
                            <td><?= h($department->active) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($department->id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created By') ?></th>
                        <td><?= $this->Number->format($department->created_by) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified By') ?></th>
                        <td><?= $this->Number->format($department->modified_by) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($department->created) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified') ?></th>
                        <td><?= h($department->modified) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Deleted') ?></th>
                        <td><?= $department->deleted ? __('Yes') : __('No'); ?></td>
                    </tr>
                                    </table>
                                    <div class="row">
                    <h4><?= __('Department Responsibilities') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($department->department_responsibilities)); ?>
                  
                </div>
                                                                        <div class="related">
                <h4><?= __('Related Department Schemes') ?></h4>
                <?php if (!empty($department->department_schemes)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Department Id') ?></th>
                                                                <th scope="col"><?= __('Scheme Status Id') ?></th>
                                                                <th scope="col"><?= __('Scheme Name') ?></th>
                                                                <th scope="col"><?= __('Scheme Detail') ?></th>
                                                                <th scope="col"><?= __('Active') ?></th>
                                                                <th scope="col"><?= __('Directive') ?></th>
                                                                <th scope="col"><?= __('Cost Of Scheme') ?></th>
                                                                <th scope="col"><?= __('Expenditure Till Date') ?></th>
                                                                <th scope="col"><?= __('Allocation For Cfy') ?></th>
                                                                <th scope="col"><?= __('Release For Cfy') ?></th>
                                                                <th scope="col"><?= __('Geo Coverage') ?></th>
                                                                <th scope="col"><?= __('Scheme Start Date') ?></th>
                                                                <th scope="col"><?= __('Scheme End Date') ?></th>
                                                                <th scope="col"><?= __('Pc2 Required') ?></th>
                                                                <th scope="col"><?= __('Pc2 Approved') ?></th>
                                                                <th scope="col"><?= __('Consultant Hired') ?></th>
                                                                <th scope="col"><?= __('Cons Subt Report') ?></th>
                                                                <th scope="col"><?= __('Pc2 Compl Date') ?></th>
                                                                <th scope="col"><?= __('Responsible Pc2 Compl') ?></th>
                                                                <th scope="col"><?= __('Pc1 Approved') ?></th>
                                                                <th scope="col"><?= __('Pc1 Approval Date') ?></th>
                                                                <th scope="col"><?= __('Pc1 Stage') ?></th>
                                                                <th scope="col"><?= __('Pc1 Compl Date') ?></th>
                                                                <th scope="col"><?= __('Pc1 Responsible') ?></th>
                                                                <th scope="col"><?= __('Hiring Required') ?></th>
                                                                <th scope="col"><?= __('Sne Approved') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Psc') ?></th>
                                                                <th scope="col"><?= __('Hiring Compl Date Psc') ?></th>
                                                                <th scope="col"><?= __('Responsible Psc') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Hiring Compl Date Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Responsible Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Market') ?></th>
                                                                <th scope="col"><?= __('Posting Though Market Media') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Entries Recorded') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Scrutiny Compl') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Intervies Cond') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Appoint Letter Issues') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Compl Date') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Respons Person') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Required') ?></th>
                                                                <th scope="col"><?= __('Land Identified') ?></th>
                                                                <th scope="col"><?= __('Land Section4 Compl') ?></th>
                                                                <th scope="col"><?= __('Land Section6 Comp') ?></th>
                                                                <th scope="col"><?= __('Land Possision Taken Over') ?></th>
                                                                <th scope="col"><?= __('Land Award Been Issued') ?></th>
                                                                <th scope="col"><?= __('Land Payment Made') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Compl Date') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Responsible') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Required') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Bidding Complete') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Po Issued') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Delivery Physical Verification Done') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Distribution Equipments') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Evidence Of Distribution') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Compl Date') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Responsible') ?></th>
                                                                <th scope="col"><?= __('Proc Services Required') ?></th>
                                                                <th scope="col"><?= __('Proc Services Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Proc Services Tech Finance Proposal Received') ?></th>
                                                                <th scope="col"><?= __('Proc Services Evaluation Process Compl') ?></th>
                                                                <th scope="col"><?= __('Proc Services Contract Awarded') ?></th>
                                                                <th scope="col"><?= __('Proc Services Status') ?></th>
                                                                <th scope="col"><?= __('Proc Services Compl Date') ?></th>
                                                                <th scope="col"><?= __('Proc Services Responsible') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Work Required') ?></th>
                                                                <th scope="col"><?= __('Is Work Carried By Civil Works') ?></th>
                                                                <th scope="col"><?= __('Is Work Commisioned Privately') ?></th>
                                                                <th scope="col"><?= __('Is Work Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Is Work Bidding Compl') ?></th>
                                                                <th scope="col"><?= __('Is Work Order Issued') ?></th>
                                                                <th scope="col"><?= __('Is Work Begun') ?></th>
                                                                <th scope="col"><?= __('Level Of Work Compl') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Compl Date') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Responsible') ?></th>
                                                                <th scope="col"><?= __('Comments') ?></th>
                                                                <th scope="col"><?= __('Scheme File') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                                <th scope="col"><?= __('Modified') ?></th>
                                                                <th scope="col"><?= __('Created By') ?></th>
                                                                <th scope="col"><?= __('Modified By') ?></th>
                                                                <th scope="col"><?= __('Deleted') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($department->department_schemes as $departmentSchemes) : ?>
                        <tr>
                                                            <td><?= h($departmentSchemes->id) ?></td>
                                                            <td><?= h($departmentSchemes->department_id) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_status_id) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_name) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_detail) ?></td>
                                                            <td><?= h($departmentSchemes->active) ?></td>
                                                            <td><?= h($departmentSchemes->directive) ?></td>
                                                            <td><?= h($departmentSchemes->cost_of_scheme) ?></td>
                                                            <td><?= h($departmentSchemes->expenditure_till_date) ?></td>
                                                            <td><?= h($departmentSchemes->allocation_for_cfy) ?></td>
                                                            <td><?= h($departmentSchemes->release_for_cfy) ?></td>
                                                            <td><?= h($departmentSchemes->geo_coverage) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_start_date) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_end_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_required) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_approved) ?></td>
                                                            <td><?= h($departmentSchemes->consultant_hired) ?></td>
                                                            <td><?= h($departmentSchemes->cons_subt_report) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_pc2_compl) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_approved) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_approval_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_stage) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_required) ?></td>
                                                            <td><?= h($departmentSchemes->sne_approved) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_psc) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_compl_date_psc) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_psc) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_compl_date_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_market) ?></td>
                                                            <td><?= h($departmentSchemes->posting_though_market_media) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_entries_recorded) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_scrutiny_compl) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_intervies_cond) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_appoint_letter_issues) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_respons_person) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_required) ?></td>
                                                            <td><?= h($departmentSchemes->land_identified) ?></td>
                                                            <td><?= h($departmentSchemes->land_section4_compl) ?></td>
                                                            <td><?= h($departmentSchemes->land_section6_comp) ?></td>
                                                            <td><?= h($departmentSchemes->land_possision_taken_over) ?></td>
                                                            <td><?= h($departmentSchemes->land_award_been_issued) ?></td>
                                                            <td><?= h($departmentSchemes->land_payment_made) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_required) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_bidding_complete) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_po_issued) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_delivery_physical_verification_done) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_distribution_equipments) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_evidence_of_distribution) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_required) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_tech_finance_proposal_received) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_evaluation_process_compl) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_contract_awarded) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_status) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_work_required) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_carried_by_civil_works) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_commisioned_privately) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_bidding_compl) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_order_issued) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_begun) ?></td>
                                                            <td><?= h($departmentSchemes->level_of_work_compl) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->comments) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_file) ?></td>
                                                            <td><?= h($departmentSchemes->created) ?></td>
                                                            <td><?= h($departmentSchemes->modified) ?></td>
                                                            <td><?= h($departmentSchemes->created_by) ?></td>
                                                            <td><?= h($departmentSchemes->modified_by) ?></td>
                                                            <td><?= h($departmentSchemes->deleted) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'DepartmentSchemes', 'action' => 'view', $departmentSchemes->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'DepartmentSchemes', 'action' => 'edit', $departmentSchemes->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'DepartmentSchemes', 'action' => 'delete', $departmentSchemes->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentSchemes->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
                                            <div class="related">
                <h4><?= __('Related Users') ?></h4>
                <?php if (!empty($department->users)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Department Id') ?></th>
                                                                <th scope="col"><?= __('Fname') ?></th>
                                                                <th scope="col"><?= __('Lname') ?></th>
                                                                <th scope="col"><?= __('Email') ?></th>
                                                                <th scope="col"><?= __('Password') ?></th>
                                                                <th scope="col"><?= __('Locked') ?></th>
                                                                <th scope="col"><?= __('Active') ?></th>
                                                                <th scope="col"><?= __('Users Roles Id') ?></th>
                                                                <th scope="col"><?= __('Avatar') ?></th>
                                                                <th scope="col"><?= __('Tel1') ?></th>
                                                                <th scope="col"><?= __('Tel2') ?></th>
                                                                <th scope="col"><?= __('Fax') ?></th>
                                                                <th scope="col"><?= __('Addr1') ?></th>
                                                                <th scope="col"><?= __('Addr2') ?></th>
                                                                <th scope="col"><?= __('City') ?></th>
                                                                <th scope="col"><?= __('State') ?></th>
                                                                <th scope="col"><?= __('Postal') ?></th>
                                                                <th scope="col"><?= __('Country') ?></th>
                                                                <th scope="col"><?= __('Comments') ?></th>
                                                                <th scope="col"><?= __('Login Failures') ?></th>
                                                                <th scope="col"><?= __('Last Login Failure') ?></th>
                                                                <th scope="col"><?= __('Last Login Success') ?></th>
                                                                <th scope="col"><?= __('Created By') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                                <th scope="col"><?= __('Modified By') ?></th>
                                                                <th scope="col"><?= __('Modified') ?></th>
                                                                <th scope="col"><?= __('Deleted') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($department->users as $users) : ?>
                        <tr>
                                                            <td><?= h($users->id) ?></td>
                                                            <td><?= h($users->department_id) ?></td>
                                                            <td><?= h($users->fname) ?></td>
                                                            <td><?= h($users->lname) ?></td>
                                                            <td><?= h($users->email) ?></td>
                                                            <td><?= h($users->password) ?></td>
                                                            <td><?= h($users->locked) ?></td>
                                                            <td><?= h($users->active) ?></td>
                                                            <td><?= h($users->users_roles_id) ?></td>
                                                            <td><?= h($users->avatar) ?></td>
                                                            <td><?= h($users->tel1) ?></td>
                                                            <td><?= h($users->tel2) ?></td>
                                                            <td><?= h($users->fax) ?></td>
                                                            <td><?= h($users->addr1) ?></td>
                                                            <td><?= h($users->addr2) ?></td>
                                                            <td><?= h($users->city) ?></td>
                                                            <td><?= h($users->state) ?></td>
                                                            <td><?= h($users->postal) ?></td>
                                                            <td><?= h($users->country) ?></td>
                                                            <td><?= h($users->comments) ?></td>
                                                            <td><?= h($users->login_failures) ?></td>
                                                            <td><?= h($users->last_login_failure) ?></td>
                                                            <td><?= h($users->last_login_success) ?></td>
                                                            <td><?= h($users->created_by) ?></td>
                                                            <td><?= h($users->created) ?></td>
                                                            <td><?= h($users->modified_by) ?></td>
                                                            <td><?= h($users->modified) ?></td>
                                                            <td><?= h($users->deleted) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'Users', 'action' => 'view', $users->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'Users', 'action' => 'edit', $users->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'Users', 'action' => 'delete', $users->id], ['confirm' => __('Are you sure you want to delete # {0}?', $users->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            </div><!--/content-->
    </section>
</div><!--/row-->
