<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\District $district
 */
$this->assign('title', 'Viewing District');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit District'), ['action' => 'edit', $district->id], ['escape' => false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete District'), ['action' => 'delete', $district->id], ['confirm' => __('Are you sure you want to delete # {0}?', $district->id), 'escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Districts'), ['action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New District'), ['action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?> </li>
    </ul>
</nav>
<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Districts</h2>
        </header>

        <div class="districts card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <tr>
                    <th scope="row"><?= __('Name') ?></th>
                    <td><?= h($district->name) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Id') ?></th>
                    <td><?= $this->Number->format($district->id) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Created By') ?></th>
                    <td><?= $this->Number->format($district->created_by) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Modified By') ?></th>
                    <td><?= $this->Number->format($district->modified_by) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Created') ?></th>
                    <td><?= h($district->created) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Modified') ?></th>
                    <td><?= h($district->modified) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Deleted') ?></th>
                    <td><?= $district->deleted ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Scheme Districts') ?></h4>
                <?php if (!empty($district->scheme_districts)) : ?>
                    <div class="table-responsive">
                        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                            <tr>
                                <th scope="col"><?= __('Id') ?></th>
                                <th scope="col"><?= __('Department Scheme Id') ?></th>
                                <th scope="col"><?= __('District Id') ?></th>
                                <th scope="col"><?= __('Created') ?></th>
                                <th scope="col"><?= __('Modified') ?></th>
                                <th scope="col"><?= __('Created By') ?></th>
                                <th scope="col"><?= __('Modified By') ?></th>
                                <!--<th  scope="col" class="actions"><?= __('Actions') ?></th>-->
                            </tr>
                            <?php foreach ($district->scheme_districts as $schemeDistricts) : ?>
                                <tr>
                                    <td><?= h($schemeDistricts->id) ?></td>
                                    <td><?= h($schemeDistricts->department_scheme_id) ?></td>
                                    <td><?= h($schemeDistricts->district_id) ?></td>
                                    <td><?= h($schemeDistricts->created) ?></td>
                                    <td><?= h($schemeDistricts->modified) ?></td>
                                    <td><?= h($schemeDistricts->created_by) ?></td>
                                    <td><?= h($schemeDistricts->modified_by) ?></td>
<!--                                    <td class="actions">
                                        <?php //$this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'SchemeDistricts', 'action' => 'view', $schemeDistricts->], ['escape' => false]) ?>
                                        <?php //$this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'SchemeDistricts', 'action' => 'edit', $schemeDistricts->], ['escape' => false]) ?>
                                        <?php //$this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'SchemeDistricts', 'action' => 'delete', $schemeDistricts->], ['confirm' => __('Are you sure you want to delete # {0}?', $schemeDistricts->), 'escape' => false]) ?>
                                    </td>-->
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div><!--/content-->
    </section>
</div><!--/row-->
