<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\RecordNote[]|\Cake\Collection\CollectionInterface $recordNotes
 */
$this->assign('title', 'Listing Record Notes');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note'), ['action' => 'add'], ['escape' => false]) ?></li>

<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Note Details'), ['controller' => 'RecordNoteDetails', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['controller' => 'RecordNoteDetails', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Record Notes') ?></h3>
        </header>

        <div id="wrapper" class="recordNotes card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0"id="table_detail">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= $this->Paginator->sort('id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('overall_status', 'Status') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('subject') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('meeting_date') ?></th>

                        <th scope="col"><?= $this->Paginator->sort('created_by', 'Responsible Officer') ?></th>


<!--                        <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($recordNotes as $recordNote):
//                        debug($recordNote);exit;
                        ?>
                        <tr>
                            <td class="text-left"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $recordNote->overall_status . '.PNG">'; ?></td>

                                                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($recordNote->id) ?></td>-->
                            <td class="text-left" data-title="Department Id"><?= h($departments[$recordNote->department_id]) ?></td>
                            <td class="text-left" data-title="Attachment"><?= h($recordNote->subject) ?></td>
                            <td class="text-left" data-title="Meeting Date"><?= h(date('d-m-Y', strtotime($recordNote->meeting_date))) ?></td>

                            <td class="text-left" data-title="Created By"><?= ucwords($users[$recordNote->created_by]) ?></td>
    <!--                            <td class="text-right" data-title="Modified By"><?= $this->Number->format($recordNote->modified_by) ?></td>
                            <td class="text-left" data-title="Created"><?= h($recordNote->created) ?></td>
                            <td class="text-left" data-title="Modified"><?= h($recordNote->modified) ?></td>-->
                            <td class="actions">
                                <a style="cursor: pointer;" onclick="showHideRow('hidden_row<?= $recordNote->id ?>');"><i class="fas fa-eye"></i> View</a>
                                <?php $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $recordNote->id], ['escape' => false]) ?>

                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $recordNote->id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $recordNote->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNote->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                        <tr id="hidden_row<?= $recordNote->id ?>" class="hidden_row" style="display:none;">
                            <td colspan=6>
                                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0" style="width:95%;margin:0 auto;">
                                    <thead>
                                        <tr>
                                            <th scope="col">Status</th>
                                            <th scope="col">Decision Made</th>
                                            <th scope="col">Completed</th>

                                            <th scope="col">Timeline</th>
                                            <th scope="col">Notes</th>

                                            <th scope="col">Responsibility</th>
                                            <th scope="col">Responsible Departments</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recordNote->record_note_details as $recordNoteDetail): ?>
                                            <tr>
                                                <td class="text-left"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $recordNoteDetail->status . '.PNG">'; ?></td>

                                                <td class="text-left" data-title="Timeline"><?= h($recordNoteDetail->decision_made) ?></td>
                                                <td class="text-left" data-title="Timeline"><?= h($recordNoteDetail->completed) ?></td>

                                                <td class="text-left" data-title="Timeline"><?= h($recordNoteDetail->timeline_label) ?></td>
                                                <td class="text-left" data-title="Timeline"><?= h($recordNoteDetail->notes) ?></td>

                                                <td class="text-left" data-title="Responsibility"><?= h($recordNoteDetail->responsibility) ?></td>
                                                <td class="text-left" data-title="Responsibility"><?php
                                                    $resp_dep = explode(',', $recordNoteDetail->respons_depts);
                                                    foreach ($resp_dep as $key => $single):
                                                        echo $departments[$single];
                                                    if($key<count($resp_dep)-1){
                                                        echo ', ';
                                                    }
                                                    endforeach;
                                                    ?></td>

                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
<!---------------------------------------------------->
<script type="text/javascript">
    function showHideRow(row) {
        $("#" + row).toggle();
    }
</script>


<!--	<div id="wrapper">

                <table border=1 id="table_detail"
                        align=center cellpadding=10>

                        <tr>
                                <th>Name</th>
                                <th>Age</th>
                                <th>Salary</th>
                                <th>Job</th>
                        </tr>

                        <tr>
                                <td>Person-1</td>
                                <td>24</td>
                                <td>60000</td>
                                <td>Computer Programmer</td>
                        </tr>
                       

                
                </table>
        </div>-->

