<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\SchemeRequest[]|\Cake\Collection\CollectionInterface $schemeRequests
 */
$this->assign('title', 'Listing Scheme Requests');
?>

<!--<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Request'), ['action' => 'add'], ['escape' => false]) ?></li>

        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>-->

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Scheme Requests') ?></h3>
        </header>

        <div class="schemeRequests card-body content">
            <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

            <div class="row">


                <div class="col-sm-2">

                    <?= $this->Form->control('status', ['class' => 'form-control', 'options' => ['pending' => 'Pending', 'approved' => 'Approved', 'rejected' => 'Rejected'], 'value' => isset($_GET['status']) ? $_GET['status'] : '']) ?>

                </div>
                <div class="col-sm-8">
                    <label for="district">Choose Department(s)</label><br/>
                    <?php
                    //debug($Departments);
                    echo $this->Form->control('department[]', ['options' => $departments, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['department']) ? $_GET['department'] : '']);
                    ?>

                </div>



                <div class="col-sm-2">
                    <br/>
                    <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary']) ?>

                </div>

            </div>
            <?= $this->Form->end() ?>
            <br/><br/>
            <?php $this->Html->link(__('<i class="fas fa-download"></i> Export all schemes to Excel'), ['action' => 'exportall'], ['id' => 'makeexcel', 'escape' => false, 'style' => 'float:right;']) ?>
            <?= $this->Html->link(__('<i class="fas fa-download"></i> Export all schemes to PDF'), ['action' => 'exportpdf'], ['id' => 'makepdf', 'escape' => false, 'style' => 'float:right;']) ?>

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_scheme_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('user_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('step_name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('status') ?></th>
                        <th scope="col" class="actions"><?= __('Type') ?></th>

                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>

<!--<th scope="col"><?= $this->Paginator->sort('modified') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $steps_Array = ['schemeprofile' => 'Scheme Profile', 'step1' => 'Is PC-II Required?', 'step2' => 'Is the PC-1 approved?', 'step3' => 'Is Hiring Required?', 'step4' => 'Is Land Acquisition Required?', 'step5' => 'Is Procurement of Goods Required?', 'step6' => 'Is Procurement of Services Required?', 'step7' => 'Is Construction/Civil Work Required?', 'custom' => 'Custom Milestone'];

                    foreach ($schemeRequests as $schemeRequest):
//                        debug($schemeRequest);exit;
                        $old = '';
                        ?>
                        <tr>
                            <td class="text-right" data-title="Id"><?= $this->Number->format($schemeRequest->id) ?></td>
                            <td><?= $schemeRequest->has('department') ? $this->Html->link($schemeRequest->department->department_name, ['controller' => 'Departments', 'action' => 'view', $schemeRequest->department->id]) : '' ?></td>
                            <td class="text-left" data-title="Department Scheme Id" id='data_<?= $schemeRequest->id ?>'><?= $schemeRequest->has('department_scheme') ? $this->Html->link($schemeRequest->department_scheme->scheme_name, ['controller' => 'DepartmentSchemes', 'action' => $schemeRequest->step_name, $schemeRequest->department_scheme->id], ['target' => '_blank']) : '' ?></td>
                            <td><?= $schemeRequest->has('user') ? $this->Html->link(ucwords($schemeRequest->user->fname . ' ' . $schemeRequest->user->lname), ['controller' => 'Users', 'action' => 'view', $schemeRequest->user->id]) : '' ?></td>
                            <td class="text-left" data-title="Step Name"><?= h($steps_Array[$schemeRequest->step_name]) . '<br/>' . $old; ?></td>
                            <td class="text-left" data-title="Status" id="status_<?= $schemeRequest->id ?>"><?= ucfirst($schemeRequest->status) ?></td>
                            <td>  
                                <?= ($schemeRequest->department_scheme->mega_project == 'Yes') ? 'Mega Project' : '' ?>
                                <br/>
                                <?= ($schemeRequest->department_scheme->scheme_category) ? $schemeRequest->department_scheme->scheme_category : '' ?>
                            </td>
                            <td class="text-left" data-title="Created"><?= date('d-m-Y', strtotime($schemeRequest->created)) ?></td>
                            <!--<td class="text-left" data-title="Modified"><?= h($schemeRequest->modified) ?></td>-->
                            <td class="actions">
                                <a id='modal_<?= $schemeRequest->id ?>' class="modal-with-form" rec_name="<?= ucwords($schemeRequest->user->fname . ' ' . $schemeRequest->user->lname); ?>" href="#modalForm" rec_message="<?= ucfirst($schemeRequest->request_details) ?>" rec_status="<?= $schemeRequest->status ?>" rec_id="<?= $schemeRequest->id ?>"><i class="fas fa-eye"></i> Approve/ Reject</a>
                                <?php //$this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $schemeRequest->id], ['escape' => false])    ?>
                                <?php // $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $schemeRequest->id], ['escape' => false])  ?>
                                <?php //$this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $schemeRequest->id], ['confirm' => __('Are you sure you want to delete # {0}?', $schemeRequest->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
<div id="modalForm" class="modal-block modal-block-primary mfp-hide">
    <section class="card">
        <form id="modal_form">
            <header class="card-header">
                <h2 class="card-title">Date Change Request</h2>
            </header>
            <div class="card-body">

                <div class="form-row">
                    <div class="form-group col-md-12">
                        <h4 id="demand"></h4>
                        <label for="inputEmail4">Approve / Reject?</label>
                        <select id="result_status" name="result_status"  class="form-control">
                            <option value="pending">Pending</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                        <small>Before approving this request, kindly make necessary changes in the scheme by clicking this link <br/><center>"<a id='make_link' href="#">LINK</a>"</center></small>
                        <br/>
                        <label for="inputEmail4">Response</label>
                        <textarea name="request_response" id="request_response" class="form-control" placeholder="(Optional)"></textarea>
                        <input type="hidden" name="id" id="page" value=""/>
                        <input type="hidden" name="rec_name" id="rec_name" value=""/>



                    </div>

                </div>


            </div>
            <footer class="card-footer">
                <div class="row">
                    <div class="col-md-12 text-right">
                        <input type="submit" class="btn btn-primary btn_click" value="Submit" />
                        <button class="btn btn-default modal-dismiss">Cancel</button>
                    </div>
                </div>
            </footer>
        </form>
    </section>
</div>
<script>
//alert(196);
    $(function () {

        $('body').on('click', '.modal-with-form', function () {
            $('#page').val($(this).attr('rec_id'));
            $('#result_status').val($(this).attr('rec_status'));
            $('#rec_name').val($(this).attr('rec_name'));
            $('#demand').html($(this).attr('rec_message'));
            $('#make_link').html($('#data_' + $(this).attr('rec_id')).html());
        });
//        alert(198);
        $('#modal_form').on('submit', function () {
//        $('body').on('click', '.btn_click', function () {

//            e.preventDefault();

            $.ajax({
                type: "POST",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>admin/SchemeRequests/save',
                data: {id: $('#page').val(), request_response: $('#request_response').val(), result_status: $('#result_status').val(), rec_name: $('#rec_name').val()}, // serializes the form's elements.
//                                data: $('#modal_form').serialize(), // serializes the form's elements.

                dataType: 'json',
                success: function (data)
                {
                    $.magnificPopup.close();

                    new PNotify({
                        title: 'Success!',
                        text: 'Your response has been saved.',
                        type: 'success',
                        delay: 2000
                    });
//                        $('.modal-with-form').hide('slow');
                    const str = $('#result_status').val();
                    const str2 = str.charAt(0).toUpperCase() + str.slice(1);
                    $('#status_' + $('#page').val()).html(str2);

                    $('#modal_' + $('#page').val()).attr('rec_status', str);

                }
            });

            return false;
//            } else {
//                new PNotify({
//                    title: 'Error!',
//                    text: 'kindly fill the reason and dates to change?',
//                    type: 'error',
//                    delay: 2000
//                });
//
//                $('.ui-pnotify ').css('z-index', '1000000000000000000000000');
//            }
        });
        var href_path = window.location.href;
        var rem = href_path.split('?');
        if (rem[1] !== undefined) {
//alert(rem[1]);
//alert($('#makeurl').attr('href'));
            var this_url = $('#makeexcel').attr('href') + '?' + rem[1];
//alert(this_url);
            $('#makeexcel').attr('href', this_url);

            var this_pdf = $('#makepdf').attr('href') + '?' + rem[1];
//alert(this_url);
            $('#makepdf').attr('href', this_pdf);
        }
    });
</script>