<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\AttachedFormation[]|\Cake\Collection\CollectionInterface $attachedFormations
 */
$this->assign('title', 'Listing Attached Formations');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Attached Formation'), ['action' => 'add'], ['escape' => false]) ?></li>

<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Attached Formations') ?></h3>
        </header>

        <div class="attachedFormations card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                        <!--<th scope="col"><?= $this->Paginator->sort('department_id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('logo') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('detail') ?></th>
<!--                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($attachedFormations as $attachedFormation): ?>
                        <tr>
                            <td class="text-right" data-title="Id"><?= $this->Number->format($attachedFormation->id) ?></td>
                            <!--<td><?= $attachedFormation->has('department') ? $this->Html->link($attachedFormation->department->department_name, ['controller' => 'Departments', 'action' => 'view', $attachedFormation->department->id]) : '' ?></td>-->
                            <td class="text-left" data-title="Name"><?= h($attachedFormation->name) ?></td>
                            <td class="text-left" data-title="Logo"><?php
                                if (file_exists(WWW_ROOT . 'img/departments/' . $attachedFormation->logo) && !empty($attachedFormation->logo)) {

                                    echo '<img src="' . $this->request->getAttribute("webroot") . 'img/departments/' . $attachedFormation->logo . '" style="height:50px">';
                                }
//                                debug();
                                ?></td>
                            <td class="text-left" data-title="Logo"><?= nl2br($attachedFormation->detail) ?></td>
    <!--                            <td class="text-left" data-title="Created"><?= h($attachedFormation->created) ?></td>
                                <td class="text-left" data-title="Modified"><?= h($attachedFormation->modified) ?></td>
                                <td class="text-right" data-title="Created By"><?= $this->Number->format($attachedFormation->created_by) ?></td>
                                <td class="text-right" data-title="Modified By"><?= $this->Number->format($attachedFormation->modified_by) ?></td>-->
                            <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-users"></i> PM\'s List (' . count($attachedFormation->users) . ')'), ['controller'=>'Users','action' => 'index', $attachedFormation->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $attachedFormation->id], ['escape' => false]) ?>
                                <?php $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $attachedFormation->id], ['confirm' => __('Are you sure you want to delete # {0}?', $attachedFormation->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
