<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');

//debug($myUser->department_id);
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is PC-I required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('pc1_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q2" style="display:<?= ($departmentScheme->pc1_required == 'Yes') ? 'block' : 'none'; ?>; margin:20px;">

                        <?php
                        $pc1required = ($departmentScheme->pc1_required == 'Yes') ? 'required' : '';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the PC-1 been approved?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('pc1_approved', [$pc1required, 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                        echo '</div><!--/row-->';

                        $departments['Other'] = 'Other';
                        ?>
                        <div id="q2_yes" style="display:<?= ($departmentScheme->pc1_approved == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                            <?php
                            echo '<div class="row"><div class="col-sm-5"><label>' . __('What was the approval date for PC-1?') . '</label></div>';
                            echo '<div class="col-sm-7">';

                            if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc1_approval_date) {
                                if ($myUser->users_roles_id == 'pm') { //cant do anything
                                    //display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_approval_date));
                                } else { //cpo
                                    //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                    if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                        //cpo cant do anything too-display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_approval_date));
                                    } else {
                                        //cpo can do and show fields again
                                        echo $this->Form->control('pc1_approval_date_disabled', ['class' => 'form-control', 'value' => ($departmentScheme->pc1_approval_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_approval_date)) : '', 'empty' => true, 'label' => false, ($departmentScheme->pc1_approved == 'Yes') ? 'required' : '', 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        echo $this->Form->hidden('pc1_approval_date', ['id' => 'pc1_approval_date']);
                                    }
                                }
                            } else {
                                //show fields to change
                                echo $this->Form->control('pc1_approval_date_disabled', ['class' => 'form-control', 'value' => ($departmentScheme->pc1_approval_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_approval_date)) : '', 'empty' => true, 'label' => false, ($departmentScheme->pc1_approved == 'Yes') ? 'required' : '', 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                echo $this->Form->hidden('pc1_approval_date', ['id' => 'pc1_approval_date']);
                            }

//                        if ($departmentScheme->locked && $departmentScheme->pc1_approval_date) {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_approval_date));
//                        } else {
//                            echo $this->Form->control('pc1_approval_date_disabled', ['class' => 'form-control', 'value' => ($departmentScheme->pc1_approval_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_approval_date)) : '', 'empty' => true, 'label' => false, ($departmentScheme->pc1_approved == 'Yes') ? 'required' : '', 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']);
//                        }
                            echo '</div>';
                            echo '</div><!--/row-->';
                            ?>
                        </div>
                        <div id="q2_no" style="display:<?= ($departmentScheme->pc1_approved == 'No') ? 'block' : 'none'; ?>;margin:20px;">

                            <?php
                            $required = ($departmentScheme->pc1_approved == 'No' && $departmentScheme->pc1_required == 'Yes') ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('What stage is the PC-1 on?') . '</label></div>';
//, 'pre-PDWP' => 'Pre-PDWP'
                            echo '<div class="col-sm-7">' . $this->Form->control('pc1_stage', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => ['preparation' => 'Preparation', 'PDWP' => 'PDWP'], 'label' => false, $required]) . '</div>';
                            echo '</div><!--/row-->';

//                        echo $this->Form->hidden('pc1_compl_old_date', ['id' => 'pc1_compl_old_date', 'value' => date('Y-m-d', strtotime($departmentScheme->pc1_compl_date))]);


                            echo '<div class="row"><div class="col-sm-5"><label id="change_verbiage">' . __('What is the expected completion date for the PC-1 process?') . '</label></div>';
                            echo '<div class="col-sm-7">';
                            if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc1_compl_date) {
                                if ($myUser->users_roles_id == 'pm') { //cant do anything
                                    //display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_compl_date));
                                } else { //cpo
                                    //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                    if ($departmentScheme->mega_project == 'Yes') {
                                        //cpo cant do anything too-display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_compl_date));
                                    } else {
                                        //cpo can do and show fields again
                                        echo $this->Form->control('pc1_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}', 'value' => ($departmentScheme->pc1_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                    }
                                }
                            } else {
                                //show fields to change
                                echo $this->Form->control('pc1_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}', 'value' => ($departmentScheme->pc1_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                            }
//                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc1_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_compl_date));
//                        } else {
//                            echo $this->Form->control('pc1_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}', 'value' => ($departmentScheme->pc1_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc1_compl_date)) : '']);
//                        }
                            echo '</div>';
                            echo '</div><!--/row-->';
//                            
//                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the PC-1 completion process?') . '</label></div>';
//                            echo '<div class="col-sm-7">' . $this->Form->control('pc1_responsible', ['class' => 'form-control', 'label' => false, $required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
//                            echo '</div><!--/row-->';

                            echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('designation_step2', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                        </div>
                        <?php
                        $departments['Other'] = 'Other';
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the PC-1 completion process?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('pc1_responsible', ['class' => 'form-control', 'label' => false, 'default' => $myUser['department_id'], 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>
                    <?php
                    echo $this->Form->control('step2_old_remarks', ['value' => $departmentScheme->step2_remarks, 'type' => 'hidden']);
                    echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('step2_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                    echo '</div><!--/row-->';

                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step1/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';           ?>
                    <?php
                    if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc1_approved == 'No' && $departmentScheme->mega_project == 'Yes') {
                        if ($schemeRequests == 0) {
                            ?>
                            <a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the PC-1 Process?</a>
                            <?php
                        } else {
                            echo "Request already pending to change date.";
                        }
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>

<script>

    $(function () {

//        var scheme_code =<?= $departmentScheme->scheme_code; ?>;
//        var year =<?= $departmentScheme->year; ?>
//
////            alert($('#cost-of-scheme').val());
//
//        var dd = {YearID: year, Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_code};
//        var myJSON = JSON.stringify(dd);
//        $.ajax({
//            url: "http://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
//            type: 'POST',
//            contentType: 'application/json; charset=utf-8',
//            data: myJSON,
//            dataType: 'json',
//            success: function (data) {
//                $('.loader').hide();
//
//                if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {
//
//                    $.each(data.Data.SchemeDetail, function (key, item) {
//                         if (item.StatusName == 'Approved' && item.Cost !== 0) {
//                            $('#q2_yes').show('slow');
//                            if (item.ApprovedDate) {
//                                var d = new Date(item.ApprovedDate)
//                                var s_month = d.getMonth() + 1;
//                                if (s_month.toString().length === 1) {
//                                    s_month = '0' + s_month;
//                                }
//                                var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
//                                $('#pc1_approval_date').val(s_date);
//                                $('#pc1-approval-date-disabled').val(s_date);
//
//                                $('#pc1-approval-date-disabled').attr('disabled', true);
//                            } else {
//                                $('#pc1_approval_date').val('');
//                                $('#pc1-approval-date-disabled').val('');
//                            }
//                            $('#pc1-approved').empty().append('<option value="Yes">Yes</option>').val('Yes');
//                            $('#pc1-approved').attr('readonly', true);
//                        }
//
//                    });
//
//                } else {
//                    alert(data.CODE + ': ' + data.Message);
//                }
//            }
//        });

        $('#pc1-approval-date-disabled').on('change', function () {
            $('#pc1_approval_date').val($(this).val());
        });
        $('body').on('change', '#pc1-required', function () {

            if ($(this).val() == 'Yes') {
                $('#q2').show('slow');
                $('#q2_yes').hide();
                $('#q2_no').hide();

//                
//                $('#q2').find('input').attr('required', true);
//                $('#q2').find('select').attr('required', true);
//                $('#q2').find('input').val('');
//                $('#q2').find('select').val('');
            } else {
                $('#q2').hide('slow');
                $('#q2').find('input').attr('required', false);
                $('#q2').find('select').attr('required', false);
                $('#q2').find('input').val('');
                $('#q2').find('select').val('');
            }
        });
        //q2
        $('body').on('change', '#pc1-approved', function () {
//                alert('q2');

            if ($(this).val() == 'Yes') {
                $('#q2_yes').show('slow');
                $('#q2_yes').find('input').attr('required', true);
                $('#q2_yes').find('select').attr('required', true);
                $('#q2_yes').find('input').val('');
                $('#q2_yes').find('select').val('');

                $('#q2_no').hide('slow');
                $('#q2_no').find('input').attr('required', false);
                $('#q2_no').find('select').attr('required', false);
                $('#q2_no').find('input').val('');
                $('#q2_no').find('select').val('');

            } else if ($(this).val() == 'No') {

                $('#q2_yes').hide('slow');
                $('#q2_yes').find('input').attr('required', false);
                $('#q2_yes').find('select').attr('required', false);
                $('#q2_yes').find('input').val('');
                $('#q2_yes').find('select').val('');

                $('#q2_no').show('slow');
                $('#q2_no').find('input').attr('required', true);
                $('#q2_no').find('select').attr('required', true);
                $('#q2_no').find('input').val('');
                $('#q2_no').find('select').val('');


            } else {
                $('#q2_yes').hide('slow');
                $('#q2_yes').find('input').attr('required', false);
                $('#q2_yes').find('select').attr('required', false);
                $('#q2_yes').find('input').val('');
                $('#q2_yes').find('select').val('');

                $('#q2_no').hide('slow');
                $('#q2_no').find('input').attr('required', false);
                $('#q2_no').find('select').attr('required', false);
                $('#q2_no').find('input').val('');
                $('#q2_no').find('select').val('');
            }
//                alert($(this).val());
            $('#designation-step2').attr('required', false);

        });

        $('body').on('change', '#pc1-stage', function () {

            if ($(this).val() == 'preparation') {
                $('#change_verbiage').html('What is the expected completion date for preparation?');
                $('#pc1-responsible').val(<?= $myUser->department_id; ?>);

            } else if ($(this).val() == 'PDWP') {
                $('#pc1-responsible').val($('#pc1-responsible option').filter(function () {
                    return $(this).html() == "Planning &amp; Development";
                }).val());
                $('#change_verbiage').html('What is the expected date for PDWP?');
            } else {
                $('#change_verbiage').html('What is the expected completion date for the PC-1 process?');
            }
        });

        if ($('#pc1-stage').val() == 'preparation') {
            $('#change_verbiage').html('What is the expected completion date for preparation?');

//                alert($('#pc1-responsible').val());
        } else if ($('#pc1-stage').val() == 'PDWP') {
            $('#change_verbiage').html('What is the expected date for PDWP?');
        } else {
            $('#change_verbiage').html('What is the expected completion date for the PC-1 process?');
        }

//        $('body').on('change', '#pc1-compl-date', function () {
//
//            if ($('#pc1_compl_old_date').val() !== '1970-01-01' && $('#pc1_compl_old_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#pc1_compl_old_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });
    });
</script>
