<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\DepartmentScheme $departmentScheme
*/
$this->assign('title', 'Viewing Department Scheme');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Department Scheme'), ['action' => 'edit', $departmentScheme->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Department Scheme'), ['action' => 'delete', $departmentScheme->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                                                                            <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                        </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Department Schemes</h2>
        </header>

    <div class="departmentSchemes card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                                                <tr>
                            <th scope="row"><?= __('Department') ?></th>
                            <td><?= $departmentScheme->has('department') ? $this->Html->link($departmentScheme->department->id, ['controller' => 'Departments', 'action' => 'view', $departmentScheme->department->id]) : '' ?></td>
                        </tr>
                                                                                                        <tr>
                            <th scope="row"><?= __('Scheme Status') ?></th>
                            <td><?= $departmentScheme->has('scheme_status') ? $this->Html->link($departmentScheme->scheme_status->id, ['controller' => 'SchemeStatuses', 'action' => 'view', $departmentScheme->scheme_status->id]) : '' ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Scheme Name') ?></th>
                            <td><?= h($departmentScheme->scheme_name) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Active') ?></th>
                            <td><?= h($departmentScheme->active) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Directive') ?></th>
                            <td><?= h($departmentScheme->directive) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Geo Coverage') ?></th>
                            <td><?= h($departmentScheme->geo_coverage) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Pc2 Required') ?></th>
                            <td><?= h($departmentScheme->pc2_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Pc2 Approved') ?></th>
                            <td><?= h($departmentScheme->pc2_approved) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Consultant Hired') ?></th>
                            <td><?= h($departmentScheme->consultant_hired) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Cons Subt Report') ?></th>
                            <td><?= h($departmentScheme->cons_subt_report) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Responsible Pc2 Compl') ?></th>
                            <td><?= h($departmentScheme->responsible_pc2_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Pc1 Approved') ?></th>
                            <td><?= h($departmentScheme->pc1_approved) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Pc1 Stage') ?></th>
                            <td><?= h($departmentScheme->pc1_stage) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Pc1 Responsible') ?></th>
                            <td><?= h($departmentScheme->pc1_responsible) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Required') ?></th>
                            <td><?= h($departmentScheme->hiring_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Sne Approved') ?></th>
                            <td><?= h($departmentScheme->sne_approved) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Through Psc') ?></th>
                            <td><?= h($departmentScheme->hiring_through_psc) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Responsible Psc') ?></th>
                            <td><?= h($departmentScheme->responsible_psc) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Through Internal Posting') ?></th>
                            <td><?= h($departmentScheme->hiring_through_internal_posting) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Responsible Internal Posting') ?></th>
                            <td><?= h($departmentScheme->responsible_internal_posting) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Through Market') ?></th>
                            <td><?= h($departmentScheme->hiring_through_market) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Posting Though Market Media') ?></th>
                            <td><?= h($departmentScheme->posting_though_market_media) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Market Entries Recorded') ?></th>
                            <td><?= h($departmentScheme->hiring_market_entries_recorded) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Market Scrutiny Compl') ?></th>
                            <td><?= h($departmentScheme->hiring_market_scrutiny_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Market Intervies Cond') ?></th>
                            <td><?= h($departmentScheme->hiring_market_intervies_cond) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Market Appoint Letter Issues') ?></th>
                            <td><?= h($departmentScheme->hiring_market_appoint_letter_issues) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Hiring Market Respons Person') ?></th>
                            <td><?= h($departmentScheme->hiring_market_respons_person) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Acquisition Required') ?></th>
                            <td><?= h($departmentScheme->land_acquisition_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Identified') ?></th>
                            <td><?= h($departmentScheme->land_identified) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Section4 Compl') ?></th>
                            <td><?= h($departmentScheme->land_section4_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Section6 Comp') ?></th>
                            <td><?= h($departmentScheme->land_section6_comp) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Possision Taken Over') ?></th>
                            <td><?= h($departmentScheme->land_possision_taken_over) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Award Been Issued') ?></th>
                            <td><?= h($departmentScheme->land_award_been_issued) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Payment Made') ?></th>
                            <td><?= h($departmentScheme->land_payment_made) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Land Acquisition Responsible') ?></th>
                            <td><?= h($departmentScheme->land_acquisition_responsible) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Required') ?></th>
                            <td><?= h($departmentScheme->proc_goods_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Tender Advertised') ?></th>
                            <td><?= h($departmentScheme->proc_goods_tender_advertised) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Bidding Complete') ?></th>
                            <td><?= h($departmentScheme->proc_goods_bidding_complete) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Po Issued') ?></th>
                            <td><?= h($departmentScheme->proc_goods_po_issued) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Delivery Physical Verification Done') ?></th>
                            <td><?= h($departmentScheme->proc_goods_delivery_physical_verification_done) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Distribution Equipments') ?></th>
                            <td><?= h($departmentScheme->proc_goods_distribution_equipments) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Evidence Of Distribution') ?></th>
                            <td><?= h($departmentScheme->proc_goods_evidence_of_distribution) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Goods Responsible') ?></th>
                            <td><?= h($departmentScheme->proc_goods_responsible) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Required') ?></th>
                            <td><?= h($departmentScheme->proc_services_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Tender Advertised') ?></th>
                            <td><?= h($departmentScheme->proc_services_tender_advertised) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Tech Finance Proposal Received') ?></th>
                            <td><?= h($departmentScheme->proc_services_tech_finance_proposal_received) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Evaluation Process Compl') ?></th>
                            <td><?= h($departmentScheme->proc_services_evaluation_process_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Contract Awarded') ?></th>
                            <td><?= h($departmentScheme->proc_services_contract_awarded) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Status') ?></th>
                            <td><?= h($departmentScheme->proc_services_status) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Proc Services Responsible') ?></th>
                            <td><?= h($departmentScheme->proc_services_responsible) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Cons Civil Work Required') ?></th>
                            <td><?= h($departmentScheme->cons_civil_work_required) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Carried By Civil Works') ?></th>
                            <td><?= h($departmentScheme->is_work_carried_by_civil_works) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Commisioned Privately') ?></th>
                            <td><?= h($departmentScheme->is_work_commisioned_privately) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Tender Advertised') ?></th>
                            <td><?= h($departmentScheme->is_work_tender_advertised) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Bidding Compl') ?></th>
                            <td><?= h($departmentScheme->is_work_bidding_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Order Issued') ?></th>
                            <td><?= h($departmentScheme->is_work_order_issued) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Is Work Begun') ?></th>
                            <td><?= h($departmentScheme->is_work_begun) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Level Of Work Compl') ?></th>
                            <td><?= h($departmentScheme->level_of_work_compl) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Cons Civil Responsible') ?></th>
                            <td><?= h($departmentScheme->cons_civil_responsible) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Comments') ?></th>
                            <td><?= h($departmentScheme->comments) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Scheme File') ?></th>
                            <td><?= h($departmentScheme->scheme_file) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($departmentScheme->id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Cost Of Scheme') ?></th>
                        <td><?= $this->Number->format($departmentScheme->cost_of_scheme) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Expenditure Till Date') ?></th>
                        <td><?= $this->Number->format($departmentScheme->expenditure_till_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Allocation For Cfy') ?></th>
                        <td><?= $this->Number->format($departmentScheme->allocation_for_cfy) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Release For Cfy') ?></th>
                        <td><?= $this->Number->format($departmentScheme->release_for_cfy) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created By') ?></th>
                        <td><?= $this->Number->format($departmentScheme->created_by) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified By') ?></th>
                        <td><?= $this->Number->format($departmentScheme->modified_by) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Scheme Start Date') ?></th>
                        <td><?= h($departmentScheme->scheme_start_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Scheme End Date') ?></th>
                        <td><?= h($departmentScheme->scheme_end_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Pc2 Compl Date') ?></th>
                        <td><?= h($departmentScheme->pc2_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Pc1 Approval Date') ?></th>
                        <td><?= h($departmentScheme->pc1_approval_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Pc1 Compl Date') ?></th>
                        <td><?= h($departmentScheme->pc1_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Hiring Compl Date Psc') ?></th>
                        <td><?= h($departmentScheme->hiring_compl_date_psc) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Hiring Compl Date Internal Posting') ?></th>
                        <td><?= h($departmentScheme->hiring_compl_date_internal_posting) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Hiring Market Compl Date') ?></th>
                        <td><?= h($departmentScheme->hiring_market_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Land Acquisition Compl Date') ?></th>
                        <td><?= h($departmentScheme->land_acquisition_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Proc Goods Compl Date') ?></th>
                        <td><?= h($departmentScheme->proc_goods_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Proc Services Compl Date') ?></th>
                        <td><?= h($departmentScheme->proc_services_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Cons Civil Compl Date') ?></th>
                        <td><?= h($departmentScheme->cons_civil_compl_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($departmentScheme->created) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified') ?></th>
                        <td><?= h($departmentScheme->modified) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Deleted') ?></th>
                        <td><?= $departmentScheme->deleted ? __('Yes') : __('No'); ?></td>
                    </tr>
                                    </table>
                                    <div class="row">
                    <h4><?= __('Scheme Detail') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($departmentScheme->scheme_detail)); ?>
                  
                </div>
                                                                        <div class="related">
                <h4><?= __('Related Scheme Districts') ?></h4>
                <?php if (!empty($departmentScheme->scheme_districts)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Department Scheme Id') ?></th>
                                                                <th scope="col"><?= __('District Id') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                                <th scope="col"><?= __('Modified') ?></th>
                                                                <th scope="col"><?= __('Created By') ?></th>
                                                                <th scope="col"><?= __('Modified By') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($departmentScheme->scheme_districts as $schemeDistricts) : ?>
                        <tr>
                                                            <td><?= h($schemeDistricts->id) ?></td>
                                                            <td><?= h($schemeDistricts->department_scheme_id) ?></td>
                                                            <td><?= h($schemeDistricts->district_id) ?></td>
                                                            <td><?= h($schemeDistricts->created) ?></td>
                                                            <td><?= h($schemeDistricts->modified) ?></td>
                                                            <td><?= h($schemeDistricts->created_by) ?></td>
                                                            <td><?= h($schemeDistricts->modified_by) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'SchemeDistricts', 'action' => 'view', $schemeDistricts->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'SchemeDistricts', 'action' => 'edit', $schemeDistricts->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'SchemeDistricts', 'action' => 'delete', $schemeDistricts->id], ['confirm' => __('Are you sure you want to delete # {0}?', $schemeDistricts->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            </div><!--/content-->
    </section>
</div><!--/row-->
