<?php

use Cake\ORM\TableRegistry;

require_once(APP . 'Vendor' . DS . 'PHPExcel' . DS . 'PHPExcel.php');

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator($this->request->getSession()->read('Auth.User.username'));


$styleArray = array(
    'font' => array(
        'bold' => true,
    ),
//    'alignment' => array(
//        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
//    ),
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'left' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'right' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        )
    ),
//    'fill' => array(
//        'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
//        'rotation' => 90,
//        'startcolor' => array(
//            'argb' => 'FFA0A0A0',
//        ),
//        'endcolor' => array(
//            'argb' => 'FFFFFFFF',
//        ),
//    ),
);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
//$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
//
//

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);

//HEADER

$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'List of Activities');
$objPHPExcel->getActiveSheet()->setCellValue('B1', 'Activity Status');
$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Responsibility');
$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Timeline');
$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Remarks');
$objPHPExcel->getActiveSheet()->setCellValue('F1', 'T/L');



//DATA
//$i++;
//$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $grantApplications->id);
//$objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $grantApplications->project_name);
//
//echo $grantApplications->id;
//
//exit;
//if u have a collection of users just loop
//DATA
$i = 2;

$departments['Other'] = 'Other';


if ($departmentScheme->pc2_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'PC-II');
    $pc2_b = ($departmentScheme->pc2_approved == 'Yes') ? 'approved' : 'not approved' . '\n';
    $pc2_b .= 'Consultant ' . ($departmentScheme->consultant_hired == 'Yes') ? 'hired' : 'not hired yet';
    $pc2_b .= 'Consultant ' . ($departmentScheme->cons_subt_report == 'Yes') ? 'submitted report' : 'haven\'t submitted report yet ';

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $pc2_b);

    $pc2_c = $departments[$departmentScheme->responsible_pc2_compl];
    if ($departmentScheme->designation_step1) {
        $pc2_c .= "\n(" . $departmentScheme->designation_step1 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $pc2_c);
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->pc2_compl_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step1_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);
    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step1_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}
if ($departmentScheme->pc1_approved) { //we need it in either case
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'PC-1');
    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, ($departmentScheme->pc1_approved == 'Yes') ? 'Approved' : ucfirst($departmentScheme->pc1_stage) . ' stage');

    $pc1_c = ($departmentScheme->pc1_approved == 'No') ? $departments[$departmentScheme->pc1_responsible] : 'Planning & Development';
    if ($departmentScheme->designation_step2) {
        $pc1_c .= "\n(" . $departmentScheme->designation_step2 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $pc1_c);
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, ($departmentScheme->pc1_approved == 'No') ? date('j F Y', strtotime($departmentScheme->pc1_compl_date)) : date('j F Y', strtotime($departmentScheme->pc1_approval_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step2_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step2_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}
if ($departmentScheme->hiring_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Hiring');

    $hiring_b = 'SNE ';
    $hiring_b .= ($departmentScheme->sne_required == 'Yes') ? 'required' : 'not required';

    if ($departmentScheme->sne_required == 'Yes') {
        $hiring_b .= "\n";
        $hiring_b .= "SNE ";
        $hiring_b .= ($departmentScheme->sne_submitted == 'Yes') ? 'submitted ' : 'not submitted ';
        $hiring_b .= 'to Finance Department';
        if ($departmentScheme->sne_submitted == 'Yes') {
            $hiring_b .= "\n";
            $hiring_b .= 'SNE ';
            $hiring_b .= ($departmentScheme->sne_approved == 'Yes') ? 'approved' : 'not approved';
        }
    }


    if ($departmentScheme->will_hiring_through_psc == 'Yes') {

        $hiring_b .= "\n";
        $hiring_b .= "     Hiring through PSC ";
        $hiring_b .= ($departmentScheme->hiring_through_psc == 'Yes') ? 'complete' : 'incomplete';
    }

    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {

        $hiring_b .= "\n";
        $hiring_b .= "     Hiring through Internal Posting ";
        $hiring_b .= ($departmentScheme->hiring_through_internal_posting == 'Yes') ? 'complete' : 'incomplete';
    }

    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $ver = ($departmentScheme->hiring_through_market == 'Yes' && $departmentScheme->posting_though_market_media == 'Yes' &&
                $departmentScheme->hiring_market_entries_recorded == 'Yes' && $departmentScheme->hiring_market_scrutiny_compl == 'Yes' &&
                $departmentScheme->hiring_market_intervies_cond == 'Yes' && $departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'complete' : 'incomplete';
        $hiring_b .= "\n";
        $hiring_b .= "     Hiring through Market " . $ver;
        $hiring_b .= "\n";
        $hiring_b .= '          Advertising ';
        $hiring_b .= ($departmentScheme->posting_though_market_media == 'Yes') ? 'complete' : 'incomplete';
        $hiring_b .= "\n";
        $hiring_b .= '          Entries ';
        $hiring_b .= ($departmentScheme->hiring_market_entries_recorded == 'Yes') ? 'recorded' : 'not recorded';
        $hiring_b .= "\n";
        $hiring_b .= '          Scrutiny / Shortlisting ';
        $hiring_b .= ($departmentScheme->hiring_market_scrutiny_compl == 'Yes') ? 'completed' : 'incomplete';
        $hiring_b .= "\n";
        $hiring_b .= '          Interviews ';
        $hiring_b .= ($departmentScheme->hiring_market_intervies_cond == 'Yes') ? 'conducted' : 'not conducted so far';
        $hiring_b .= "\n";
        $hiring_b .= '          Appointment letters ';
        $hiring_b .= ($departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'issued' : 'not issued';
    }

//    debug($hiring_b);
//    exit;

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $hiring_b);
    $objPHPExcel->getActiveSheet()->getStyle('B' . $i)->getAlignment()->setWrapText(true);


    $hiring_c = "\n";
    if ($departmentScheme->sne_submitted == 'No') {
        $hiring_c .= $departments[$departmentScheme->department_id];
    }

    $hiring_c .= "\n";
    if ($departmentScheme->sne_approved == 'No') {
        $hiring_c .= "Finance";
    }
    if ($departmentScheme->will_hiring_through_psc == 'Yes') {

        $hiring_c .= "\n\n";
        $hiring_c .= "PSC: " . $departments[$departmentScheme->responsible_psc];
        if ($departmentScheme->designation_step3_psc) {
            $hiring_c .= "(" . $departmentScheme->designation_step3_psc . ')';
        }
    }
    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
        $hiring_c .= "\n\n";
        $hiring_c .= "Internal Posting: " . $departments[$departmentScheme->responsible_internal_posting];
        if ($departmentScheme->designation_step3_ip) {
            $hiring_c .= "\n(" . $departmentScheme->designation_step3_ip . ')';
        }
    }
    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $hiring_c .= "\n\n";
        $hiring_c .= "Market: " . $departments[$departmentScheme->hiring_market_respons_person];
        if ($departmentScheme->designation_step3_market) {
            $hiring_c .= "\n(" . $departmentScheme->designation_step3_market . ')';
        }
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $hiring_c);
    $objPHPExcel->getActiveSheet()->getStyle('C' . $i)->getAlignment()->setWrapText(true);

    $hiring_d = "\n";
    $hiring_d .= ($departmentScheme->sne_submitted == 'No') ? date('j F Y', strtotime($departmentScheme->sne_submission_date)) : '';
    $hiring_d .= "\n";
    $hiring_d .= ($departmentScheme->sne_approved == 'No') ? '' . date('j F Y', strtotime($departmentScheme->sne_approval_date)) : '';
    if ($departmentScheme->will_hiring_through_psc == 'Yes') {

        $hiring_d .= "\n\n";
        $hiring_d .= "PSC: " . date('j F Y', strtotime($departmentScheme->hiring_compl_date_psc));
    }

    $hiring_d .= "\n";
    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
        $hiring_d .= "\n";
        $hiring_d .= "Internal Posting: " . date('j F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
    }

    $hiring_d .= "\n";
    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $hiring_d .= "\n";
        $hiring_d .= "Market: " . date('j F Y', strtotime($departmentScheme->hiring_market_compl_date));
    }

    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, $hiring_d);
    $objPHPExcel->getActiveSheet()->getStyle('D' . $i)->getAlignment()->setWrapText(true);


    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step3_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step3_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}

if ($departmentScheme->land_acquisition_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Land Acquisition');

    $land_b = "Land Identification ";
    $land_b .= ($departmentScheme->land_identified == 'Yes') ? 'complete' : 'incomplete';
    $land_b .= "\nSection 4 ";
    $land_b .= ($departmentScheme->land_section4_compl == 'Yes') ? 'complete' : 'incomplete';
    $land_b .= "\nSection 6 ";
    $land_b .= ($departmentScheme->land_section6_compl == 'Yes') ? 'complete' : 'incomplete';
    $land_b .= "\nLand Possession ";
    $land_b .= ($departmentScheme->land_possision_taken_over == 'Yes') ? 'taken over' : 'not taken over';
    $land_b .= "\nLand Award ";
    $land_b .= ($departmentScheme->land_award_been_issued == 'Yes') ? 'been issued' : 'not issued';
    $land_b .= "\nPayment ";
    $land_b .= ($departmentScheme->land_payment_made == 'Yes') ? 'made' : 'not made';

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $land_b);
    $objPHPExcel->getActiveSheet()->getStyle('B' . $i)->getAlignment()->setWrapText(true);


    $land_c = $departments[$departmentScheme->land_acquisition_responsible];
    if ($departmentScheme->designation_step4) {
        $land_c .= "\n(" . $departmentScheme->designation_step4 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $land_c);
    $objPHPExcel->getActiveSheet()->getStyle('C' . $i)->getAlignment()->setWrapText(true);


    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->land_acquisition_compl_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step4_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step4_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}
if ($departmentScheme->proc_goods_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Procurement of Goods');

    $goods_b = "Advertisement ";
    $goods_b .= ($departmentScheme->proc_goods_tender_advertised == 'Yes') ? 'complete' : 'incomplete';
    $goods_b .= "\nBidding ";
    $goods_b .= ($departmentScheme->proc_goods_bidding_complete == 'Yes') ? 'complete' : 'incomplete';
    $goods_b .= "\nPurchase orders ";
    $goods_b .= ($departmentScheme->proc_goods_po_issued == 'Yes') ? 'issuesd' : 'not issued';
    $goods_b .= "\nDelivery ";
    $goods_b .= ($departmentScheme->proc_goods_delivery_physical_verification_done == 'Yes') ? 'complete' : 'incomplete';
    $goods_b .= "\nDistribution ";
    $goods_b .= ($departmentScheme->proc_goods_distribution_equipments == 'Yes') ? 'complete' : 'incomplete';

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $goods_b);
    $objPHPExcel->getActiveSheet()->getStyle('B' . $i)->getAlignment()->setWrapText(true);

    $goods_c = $departments[$departmentScheme->proc_goods_responsible];
    if ($departmentScheme->designation_step5) {
        $goods_c .= "\n(" . $departmentScheme->designation_step5 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $goods_c);
    $objPHPExcel->getActiveSheet()->getStyle('C' . $i)->getAlignment()->setWrapText(true);

    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->proc_goods_compl_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step5_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step5_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}


if ($departmentScheme->proc_services_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Procurement of Services ');

    $serv_b = "Advertisement ";
    $serv_b .= ($departmentScheme->proc_services_tender_advertised == 'Yes') ? 'complete' : 'incomplete';
    $serv_b .= "\nTechnical/Financial Proposal ";
    $serv_b .= ($departmentScheme->proc_services_tech_finance_proposal_received == 'Yes') ? 'received ' : 'not received';
    $serv_b .= "\nEvaluation of proposals ";
    $serv_b .= ($departmentScheme->proc_services_evaluation_process_compl == 'Yes') ? 'complete' : 'incomplete';
    $serv_b .= "\nContract ";
    $serv_b .= ($departmentScheme->proc_services_contract_awarded == 'Yes') ? 'awarded' : 'not awarded';
    $serv_b .= "\nCompletion Status:";
    $serv_b .= ($departmentScheme->proc_services_status) ? $departmentScheme->proc_services_status . '%' : 'Not started';

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $serv_b);
    $objPHPExcel->getActiveSheet()->getStyle('B' . $i)->getAlignment()->setWrapText(true);

    $serv_c = $departments[$departmentScheme->proc_services_responsible];
    if ($departmentScheme->designation_step6) {
        $serv_c .= "\n(" . $departmentScheme->designation_step6 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $serv_c);
    $objPHPExcel->getActiveSheet()->getStyle('C' . $i)->getAlignment()->setWrapText(true);

    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->proc_services_compl_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step6_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step6_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}
if ($departmentScheme->cons_civil_work_required == 'Yes') {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Construction/civil works ');


    $cons_b = "Work by C & W: ";
    $cons_b .= $departmentScheme->is_work_carried_by_civil_works;
    $cons_b .= "\nWork by Other Agency: ";
    $cons_b .= $departmentScheme->is_work_commisioned_privately;
    if ($departmentScheme->is_work_commisioned_privately == 'Yes') {
        if ($departmentScheme->cons_civil_private_type) {
            $m_array = ['single_source' => 'Single Source', 'open_tender' => 'Open Tendering'];
            $cons_b .= "\n     Work Type: ";
            $cons_b .= $m_array[$departmentScheme->cons_civil_private_type];
        }
        if ($departmentScheme->cons_civil_private_type == 'open_tender') {

            $cons_b .= "\n     Advertisement ";
            $cons_b .= ($departmentScheme->is_work_tender_advertised == 'Yes') ? 'complete' : 'incomplete';
            $cons_b .= "\n     Bidding ";
            $cons_b .= ($departmentScheme->is_work_bidding_compl == 'Yes') ? 'complete' : 'incomplete';
            $cons_b .= "\n     Work Order ";
            $cons_b .= ($departmentScheme->is_work_order_issued == 'Yes') ? 'issued' : 'not issued';
        }
    }
    $cons_b .= "\n     Work ";
    $cons_b .= ($departmentScheme->is_work_begun == 'Yes') ? 'started' : 'not started';

    if ($departmentScheme->is_work_begun == 'Yes') {
        $cons_b .= "\n     Completion Status: ";
        $cons_b .= ($departmentScheme->level_of_work_compl) ? $departmentScheme->level_of_work_compl . '%' : 'Not started';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, $cons_b);
    $objPHPExcel->getActiveSheet()->getStyle('B' . $i)->getAlignment()->setWrapText(true);

    $cons_c = $departments[$departmentScheme->cons_civil_responsible];
    if ($departmentScheme->designation_step7) {
        $cons_c .= "\n(" . $departmentScheme->designation_step7 . ')';
    }

    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, $cons_c);
    $objPHPExcel->getActiveSheet()->getStyle('C' . $i)->getAlignment()->setWrapText(true);
//
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->cons_civil_compl_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, str_replace('<br />', "\n", $departmentScheme->step7_remarks));
    $objPHPExcel->getActiveSheet()->getStyle('E' . $i)->getAlignment()->setWrapText(true);


    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->step7_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
}

foreach ($fetch_custom_details as $details):
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, ucfirst($details->milestone_name));
    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, nl2br(ucfirst($details->way_forward)));
    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, ucfirst($departments[$details->responsibility]));
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($details->completion_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, '');

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
//    echo ;
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $details->milestone_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('F' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

    $i++;
endforeach;
$i++;   
//overall status
$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Overall Status');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, '');
$objPHPExcel->getActiveSheet()->setCellValue('C' . $i, '');
$SchemeDistricts = TableRegistry::get('SchemesLogs');
$choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();

if (isset($choosen_nav_districts->created)) {
    $over_d = date('j F Y', strtotime($choosen_nav_districts->created));
} else {
    $over_d = "-";
}
$objPHPExcel->getActiveSheet()->setCellValue('D' . $i, 'Updated:' . $over_d);
$objPHPExcel->getActiveSheet()->setCellValue('E' . $i, ucfirst($departmentScheme->final_comments));

$objDrawing = new PHPExcel_Worksheet_Drawing();
$objDrawing->setName('Logo');
$objDrawing->setDescription('Logo');
//    echo ;
$logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $departmentScheme->overall_status . '.PNG'; // Provide path to your logo file

$objDrawing->setPath($logo);

$objDrawing->setCoordinates('F' . $i);
$objDrawing->setHeight(20); // logo height
$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

$i++;

//date of completion
$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Date of completion');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, '');
$objPHPExcel->getActiveSheet()->setCellValue('C' . $i, '');

$objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($departmentScheme->scheme_end_date)));
$objPHPExcel->getActiveSheet()->setCellValue('E' . $i, '');
$objPHPExcel->getActiveSheet()->setCellValue('F' . $i, '');

$i++;
$i++;
$objPHPExcel->getActiveSheet()->getStyle('A' . $i)->getFont()->setSize(13);
$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Scheme Financial Progress Details');

$i++;
$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Total cost (in Rs. millions)');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, number_format($departmentScheme->cost_of_scheme, 3));

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Current allocation (in Rs. millions)');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, number_format($departmentScheme->allocation_for_cfy, 3));

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Previous Expenditure (in Rs. millions)');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, number_format($departmentScheme->expenditure_till_date, 3));

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Releases Current Year (in Rs. millions)');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, number_format($departmentScheme->release_for_cfy, 3));

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A' . $i, 'Expenditure Current Year (in Rs. millions)');
$objPHPExcel->getActiveSheet()->setCellValue('B' . $i, number_format($departmentScheme->progressive_expenditure, 3));




// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Tracker');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

//call the function in the controller with $output_type = F and $file with complete path to the file, to generate the file in the server for example attach to email
if (isset($output_type) && $output_type == 'F') {
    echo "132";
    exit;
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save($file);
} else {
//    echo "136";exit;
    // Redirect output to a client's web browser (Excel2007)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $file . '"');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save('php://output');
}