<?php
declare(strict_types=1);

namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * DepartmentSchemesFixture
 */
class DepartmentSchemesFixture extends TestFixture
{
    /**
     * Fields
     *
     * @var array
     */
    // phpcs:disable
    public $fields = [
        'id' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'year' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => '2020', 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'department_id' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'user_id' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => '0', 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'overall_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => '1', 'comment' => '5=danger, 4=off_track, 3=on_track, 2=completed, 1=not_started', 'precision' => null, 'autoIncrement' => null],
        'step1_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step2_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step3_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step4_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step5_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step6_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'step7_status' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'scheme_code' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'scheme_name' => ['type' => 'string', 'length' => 255, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'scheme_type' => ['type' => 'string', 'length' => null, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'scheme_detail' => ['type' => 'text', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'active' => ['type' => 'string', 'length' => null, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'directive' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'cost_of_scheme' => ['type' => 'decimal', 'length' => 10, 'precision' => 3, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'expenditure_till_date' => ['type' => 'decimal', 'length' => 10, 'precision' => 3, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'allocation_for_cfy' => ['type' => 'decimal', 'length' => 10, 'precision' => 3, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'release_for_cfy' => ['type' => 'decimal', 'length' => 10, 'precision' => 3, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'geo_coverage' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'scheme_start_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'scheme_end_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'pc2_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'pc2_approved' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'consultant_hired' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'cons_subt_report' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'pc2_compl_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'responsible_pc2_compl' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'pc1_approved' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'pc1_approval_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'pc1_stage' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'pc1_compl_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'pc1_responsible' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'sne_approved' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'sne_approval_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'will_hiring_through_psc' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_through_psc' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_compl_date_psc' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'responsible_psc' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'will_hiring_through_internal_posting' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_through_internal_posting' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_compl_date_internal_posting' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'responsible_internal_posting' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'will_hiring_through_market' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_through_market' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'posting_though_market_media' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_market_entries_recorded' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_market_scrutiny_compl' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_market_intervies_cond' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_market_appoint_letter_issues' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'hiring_market_compl_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'hiring_market_respons_person' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_acquisition_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_identified' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_section4_compl' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_section6_comp' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_possision_taken_over' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_award_been_issued' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_payment_made' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'land_acquisition_compl_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'land_acquisition_responsible' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_tender_advertised' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_bidding_complete' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_po_issued' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_delivery_physical_verification_done' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_distribution_equipments' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_evidence_of_distribution' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_goods_compl_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'proc_goods_responsible' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_tender_advertised' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_tech_finance_proposal_received' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_evaluation_process_compl' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_contract_awarded' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_status' => ['type' => 'string', 'length' => null, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'proc_services_compl_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'proc_services_responsible' => ['type' => 'string', 'length' => 90, 'null' => false, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'cons_civil_work_required' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_carried_by_civil_works' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_commisioned_privately' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'cons_civil_private_type' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_tender_advertised' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_bidding_compl' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_order_issued' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'is_work_begun' => ['type' => 'string', 'length' => null, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'level_of_work_compl' => ['type' => 'string', 'length' => null, 'null' => false, 'default' => '0', 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'cons_civil_compl_date' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'cons_civil_responsible' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'comments' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'scheme_file' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step1' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step2' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step3_psc' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step3_ip' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step3_market' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step4' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step5' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step6' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'designation_step7' => ['type' => 'string', 'length' => 90, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => '', 'precision' => null],
        'last_cron_job_date' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'created' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'modified' => ['type' => 'date', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'created_by' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'modified_by' => ['type' => 'integer', 'length' => null, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'deleted' => ['type' => 'boolean', 'length' => null, 'null' => false, 'default' => '0', 'comment' => '', 'precision' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'MyISAM',
            'collation' => 'latin1_swedish_ci'
        ],
    ];
    // phpcs:enable
    /**
     * Init method
     *
     * @return void
     */
    public function init(): void
    {
        $this->records = [
            [
                'id' => 1,
                'year' => 1,
                'department_id' => 1,
                'user_id' => 1,
                'overall_status' => 1,
                'step1_status' => 1,
                'step2_status' => 1,
                'step3_status' => 1,
                'step4_status' => 1,
                'step5_status' => 1,
                'step6_status' => 1,
                'step7_status' => 1,
                'scheme_code' => 1,
                'scheme_name' => 'Lorem ipsum dolor sit amet',
                'scheme_type' => 'Lorem ipsum dolor sit amet',
                'scheme_detail' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
                'active' => 'Lorem ipsum dolor sit amet',
                'directive' => 'Lorem ipsum dolor sit amet',
                'cost_of_scheme' => 1.5,
                'expenditure_till_date' => 1.5,
                'allocation_for_cfy' => 1.5,
                'release_for_cfy' => 1.5,
                'geo_coverage' => 'Lorem ipsum dolor sit amet',
                'scheme_start_date' => '2021-02-25',
                'scheme_end_date' => '2021-02-25',
                'pc2_required' => 'Lorem ipsum dolor sit amet',
                'pc2_approved' => 'Lorem ipsum dolor sit amet',
                'consultant_hired' => 'Lorem ipsum dolor sit amet',
                'cons_subt_report' => 'Lorem ipsum dolor sit amet',
                'pc2_compl_date' => '2021-02-25',
                'responsible_pc2_compl' => 'Lorem ipsum dolor sit amet',
                'pc1_approved' => 'Lorem ipsum dolor sit amet',
                'pc1_approval_date' => '2021-02-25',
                'pc1_stage' => 'Lorem ipsum dolor sit amet',
                'pc1_compl_date' => '2021-02-25',
                'pc1_responsible' => 'Lorem ipsum dolor sit amet',
                'hiring_required' => 'Lorem ipsum dolor sit amet',
                'sne_approved' => 'Lorem ipsum dolor sit amet',
                'sne_approval_date' => '2021-02-25',
                'will_hiring_through_psc' => 'Lorem ipsum dolor sit amet',
                'hiring_through_psc' => 'Lorem ipsum dolor sit amet',
                'hiring_compl_date_psc' => '2021-02-25',
                'responsible_psc' => 'Lorem ipsum dolor sit amet',
                'will_hiring_through_internal_posting' => 'Lorem ipsum dolor sit amet',
                'hiring_through_internal_posting' => 'Lorem ipsum dolor sit amet',
                'hiring_compl_date_internal_posting' => '2021-02-25',
                'responsible_internal_posting' => 'Lorem ipsum dolor sit amet',
                'will_hiring_through_market' => 'Lorem ipsum dolor sit amet',
                'hiring_through_market' => 'Lorem ipsum dolor sit amet',
                'posting_though_market_media' => 'Lorem ipsum dolor sit amet',
                'hiring_market_entries_recorded' => 'Lorem ipsum dolor sit amet',
                'hiring_market_scrutiny_compl' => 'Lorem ipsum dolor sit amet',
                'hiring_market_intervies_cond' => 'Lorem ipsum dolor sit amet',
                'hiring_market_appoint_letter_issues' => 'Lorem ipsum dolor sit amet',
                'hiring_market_compl_date' => '2021-02-25',
                'hiring_market_respons_person' => 'Lorem ipsum dolor sit amet',
                'land_acquisition_required' => 'Lorem ipsum dolor sit amet',
                'land_identified' => 'Lorem ipsum dolor sit amet',
                'land_section4_compl' => 'Lorem ipsum dolor sit amet',
                'land_section6_comp' => 'Lorem ipsum dolor sit amet',
                'land_possision_taken_over' => 'Lorem ipsum dolor sit amet',
                'land_award_been_issued' => 'Lorem ipsum dolor sit amet',
                'land_payment_made' => 'Lorem ipsum dolor sit amet',
                'land_acquisition_compl_date' => '2021-02-25',
                'land_acquisition_responsible' => 'Lorem ipsum dolor sit amet',
                'proc_goods_required' => 'Lorem ipsum dolor sit amet',
                'proc_goods_tender_advertised' => 'Lorem ipsum dolor sit amet',
                'proc_goods_bidding_complete' => 'Lorem ipsum dolor sit amet',
                'proc_goods_po_issued' => 'Lorem ipsum dolor sit amet',
                'proc_goods_delivery_physical_verification_done' => 'Lorem ipsum dolor sit amet',
                'proc_goods_distribution_equipments' => 'Lorem ipsum dolor sit amet',
                'proc_goods_evidence_of_distribution' => 'Lorem ipsum dolor sit amet',
                'proc_goods_compl_date' => '2021-02-25',
                'proc_goods_responsible' => 'Lorem ipsum dolor sit amet',
                'proc_services_required' => 'Lorem ipsum dolor sit amet',
                'proc_services_tender_advertised' => 'Lorem ipsum dolor sit amet',
                'proc_services_tech_finance_proposal_received' => 'Lorem ipsum dolor sit amet',
                'proc_services_evaluation_process_compl' => 'Lorem ipsum dolor sit amet',
                'proc_services_contract_awarded' => 'Lorem ipsum dolor sit amet',
                'proc_services_status' => 'Lorem ipsum dolor sit amet',
                'proc_services_compl_date' => '2021-02-25',
                'proc_services_responsible' => 'Lorem ipsum dolor sit amet',
                'cons_civil_work_required' => 'Lorem ipsum dolor sit amet',
                'is_work_carried_by_civil_works' => 'Lorem ipsum dolor sit amet',
                'is_work_commisioned_privately' => 'Lorem ipsum dolor sit amet',
                'cons_civil_private_type' => 'Lorem ipsum dolor sit amet',
                'is_work_tender_advertised' => 'Lorem ipsum dolor sit amet',
                'is_work_bidding_compl' => 'Lorem ipsum dolor sit amet',
                'is_work_order_issued' => 'Lorem ipsum dolor sit amet',
                'is_work_begun' => 'Lorem ipsum dolor sit amet',
                'level_of_work_compl' => 'Lorem ipsum dolor sit amet',
                'cons_civil_compl_date' => '2021-02-25',
                'cons_civil_responsible' => 'Lorem ipsum dolor sit amet',
                'comments' => 'Lorem ipsum dolor sit amet',
                'scheme_file' => 'Lorem ipsum dolor sit amet',
                'designation_step1' => 'Lorem ipsum dolor sit amet',
                'designation_step2' => 'Lorem ipsum dolor sit amet',
                'designation_step3_psc' => 'Lorem ipsum dolor sit amet',
                'designation_step3_ip' => 'Lorem ipsum dolor sit amet',
                'designation_step3_market' => 'Lorem ipsum dolor sit amet',
                'designation_step4' => 'Lorem ipsum dolor sit amet',
                'designation_step5' => 'Lorem ipsum dolor sit amet',
                'designation_step6' => 'Lorem ipsum dolor sit amet',
                'designation_step7' => 'Lorem ipsum dolor sit amet',
                'last_cron_job_date' => '2021-02-25',
                'created' => '2021-02-25',
                'modified' => '2021-02-25',
                'created_by' => 1,
                'modified_by' => 1,
                'deleted' => 1,
            ],
        ];
        parent::init();
    }
}
