<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * Departments Controller
 *
 * @property \App\Model\Table\DepartmentsTable $Departments
 * @method \App\Model\Entity\Department[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DepartmentsController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
//        debug($this->request->getParam('action'));exit;
        if ($this->Authentication->getResult()->getData() && $this->Authentication->getResult()->getData()->users_roles_id == 'cpo') {
            $this->Flash->error(__('Oops, you are not allowed that location'));

            $this->redirect(['controller' => 'Departments', 'action' => 'view', 'prefix' => false]);
        }
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
        $this->Authentication->addUnauthenticatedActions([]);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];

        if (isset($_GET['name']) && $_GET['name'] !== '') {
            $cond[] = ['Departments.department_name like' => '%' . $_GET['name'] . '%'];
        }

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//            debug($cond);exit;

        $this->paginate = [
//            'contain' => ['DepartmentSchemes','Users'],
            'contain' => ['DepartmentSchemes'=>['conditions'=>['deleted'=>0]], 'Users' => ['conditions' => ['users_roles_id' => 'cpo', 'deleted' => 0]]],
            'conditions' => $cond,
            'order' => ['department_name'], 'limit' => 35
        ];

        $departments = $this->paginate($this->Departments);

        $this->set(compact('departments'));
    }

    /**
     * View method
     *
     * @param string|null $id Department id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $department = $this->Departments->get($id, [
            'contain' => ['DepartmentSchemes'],
        ]);

        $this->set(compact('department'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
//    public function add() {
//        $department = $this->Departments->newEmptyEntity();
//        if ($this->request->is('post')) {
//            $mValidated = true;
//            $mPostData = $this->request->getData();
//            unset($mPostData['department_logo']);
//            $department = $this->Departments->patchEntity($department, $mPostData);
//            if ($this->request->getData()['department_logo']->getClientFileName()) {
//
//                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
//                $img_ext = explode('.', $this->request->getData()['department_logo']->getClientFileName());
//                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
////                debug($slider->image);
//                if (in_array($img_ext[1], $ext_array)) {
//                    $path = WWW_ROOT . 'img' . DS . 'departments' . DS . $new_name;
//                    $image = $this->request->getData()['department_logo'];
//                    $image->moveTo($path);
//                    $department->department_logo = $new_name;
//                } else {
//                    $mValidated = false;
//                    $this->Flash->error(__('Invalid image type provided.'));
//                }
//            } else {
//                $department->department_logo = '';
//            }
//            if ($mValidated == true) {
//                $department->created_by = $this->request->getAttribute('identity')->getIdentifier();
//                $department->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//
//                if ($this->Departments->save($department)) {
//                    $this->Flash->success(__('The department has been saved.'));
//
//                    return $this->redirect(['action' => 'index']);
//                }
//            }
//            $this->Flash->error(__('The department could not be saved. Please, try again.'));
//        }
//        $this->set(compact('department'));
//    }

    /**
     * Edit method
     *
     * @param string|null $id Department id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $department = $this->Departments->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();
            unset($mPostData['department_logo']);

            $department = $this->Departments->patchEntity($department, $mPostData);
            $image = $this->request->getData()['department_logo'];

            if ($image->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $image->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'departments' . DS . $new_name;
                    $image->moveTo($path);
                    $department->department_logo = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($department->department_logo);
            }
//            debug($department);
//            exit;
            if ($mValidated == true) {
                $department->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//                debug($department);exit;
                if ($this->Departments->save($department)) {
                    $this->Flash->success(__('The department has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The department could not be saved. Please, try again.'));
        }
        $this->set(compact('department'));
    }

    public function remove($id = null) {
        $departmentScheme = $this->Departments->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'departments' . DS . $departmentScheme->department_logo);
        $departmentScheme->department_logo = '';
        if ($this->Departments->save($departmentScheme)) {

            $this->Flash->success(__('Department logo has been removed.'));

            return $this->redirect(['action' => 'edit', $id]);
        }
    }

    /**
     * Delete method
     *
     * @param string|null $id Department id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $department = $this->Departments->get($id);

        $mUserData['deleted'] = '1';

//        if ($this->Departments->delete($department)) {

        $schemeStatus = $this->Departments->patchEntity($department, $mUserData);
        if ($this->Departments->save($schemeStatus)) {

            $this->Flash->success(__('The department has been deleted.'));
        } else {
            $this->Flash->error(__('The department could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
