<?php

declare(strict_types = 1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */

namespace App\Controller;

use Cake\Controller\Controller;
use Cake\Event\Event;

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link https://book.cakephp.org/4/en/controllers.html#the-app-controller
 */
class AppController extends Controller {

    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('FormProtection');`
     *
     * @return void
     */
    public function initialize(): void {

        parent::initialize();

//        $this->loadComponent('RequestHandler');

        $this->loadComponent('RequestHandler', [
//            'enableBeforeRedirect' => false,
        ]);

        $this->loadComponent('Flash');

        /*
         * Enable the following component for recommended CakePHP form protection settings.
         * see https://book.cakephp.org/4/en/controllers/components/form-protection.html
         */
        //$this->loadComponent('FormProtection');
        // Add this line to check authentication result and lock your site
        $this->loadComponent('Authentication.Authentication');

//                $myUser = $this->Authentication;
//        debug($this->request->getAttribute('identity'));exit;
        if ($this->request->getAttribute('identity')) {
            //reload user info in case something's changed after logged-in
            $this->loadModel('Users');
            $query = $this->Users->find('all', [
                'contain' => ['UsersRoles'],
                'conditions' => ['Users.id' => $this->request->getAttribute('identity')->getIdentifier()],
                'limit' => 1,
            ]);

            $myUser = $query->first();
            unset($myUser['password']);

            if ($myUser['avatar'] == '') {
                $myUser['avatar'] = 'logged-user.jpg';
            }
//            debug($myUser);exit;
            $this->set('myUser', $myUser);

            $this->loadModel('Departments');
            if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
//        debug();
                $mydept = $this->Departments->find('all', ['conditions' => ['Departments.id' => $this->Authentication->getResult()->getData()->department_id]])->first()->toArray();

                if ($this->Authentication->getResult()->getData()->attached_formation_id) {
                    $this->loadModel('AttachedFormations');
                    $formation = $this->AttachedFormations->find('all', ['conditions' => ['id' => $this->Authentication->getResult()->getData()->attached_formation_id]])->first()->toArray();
                    $this->set(compact('formation'));
                }
                $this->loadModel('DepartmentSchemes');
                $schemes_count = $this->DepartmentSchemes->find('all', ['conditions' => ['deleted'=>0,'user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->count();
//                debug($schemes_count);exit;

                $this->set(compact('mydept', 'schemes_count'));
            } else if ($this->Authentication->getResult()->getData()->users_roles_id == 'cpo') {
//        debug();
                $mydept = $this->Departments->find('all', ['conditions' => ['Departments.id' => $this->Authentication->getResult()->getData()->department_id]])->first()->toArray();

                $this->loadModel('DepartmentSchemes');
                $schemes_count = $this->DepartmentSchemes->find('all', ['conditions' => ['deleted'=>0,'department_id' => $this->Authentication->getResult()->getData()->department_id]])->count();
//                debug($schemes_count);exit;

                $this->loadModel('AttachedFormations');
                $formations_count = $this->AttachedFormations->find('all', ['conditions' => ['department_id' => $this->Authentication->getResult()->getData()->department_id]])->count();


                $pms_count = $this->Users->find('all', ['conditions' => ['Users.deleted' => 0, 'Users.users_roles_id' => 'pm', 'department_id' => $this->Authentication->getResult()->getData()->department_id]])->count();

                $this->set(compact('mydept', 'schemes_count', 'formations_count', 'pms_count'));
            } else {
                //counter to show in the left navigation
                $users_count = $this->Users->find('all', ['conditions' => ['Users.deleted' => 0, 'Users.users_roles_id IN ' => ['admin', 'chief']]])->count();
                $this->loadModel('Districts');
                $dist_count = $this->Districts->find('all', ['conditions' => ['Districts.deleted' => 0]])->count();
                //assign chief departments

                if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
                    $this->loadModel('AssignChiefDepartments');
                    $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
//                    $cond_dept[] = ['Departments.id IN ' => $get_departments];
                    $depts_count = $this->Departments->find('all', ['conditions' => ['Departments.deleted' => 0, 'Departments.id IN '=>$get_departments
//                    ,'Departments.department_name NOT LIKE'=>'Other'
                        ]])->count();
                } else {
                    $depts_count = $this->Departments->find('all', ['conditions' => ['Departments.deleted' => 0
//                    ,'Departments.department_name NOT LIKE'=>'Other'
                        ]])->count();
                }


                $this->loadModel('SchemeStatuses');
                $status_count = $this->SchemeStatuses->find('all', ['conditions' => ['SchemeStatuses.deleted' => 0]])->count();
                
                $this->loadModel('Comments');
                $comments_count = $this->Comments->find('all',['conditions' => ['Comments.parent_id' => 0]])->count();//['conditions' => ['Comments.user_id' => $this->request->getAttribute('identity')->getIdentifier()]]
                $this->set(compact('users_count', 'depts_count', 'status_count', 'dist_count','comments_count'));
            }

//            debug($dist_count);
//            exit;
        }
    }

    // in src/Controller/AppController.php
    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // for all controllers in our application, make index and view
        // actions public, skipping the authentication check
        $this->Authentication->addUnauthenticatedActions([]);
    }

}
