<?php

declare(strict_types = 1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * CustomMilestone Entity
 *
 * @property int $id
 * @property int $department_schemes_id
 * @property string $milestone_name
 * @property string $way_forward
 * @property string $is_completed
 * @property \Cake\I18n\FrozenDate $completion_date
 * @property int $responsibility
 * @property int $milestone_status
 * @property \Cake\I18n\FrozenTime $created
 * @property \Cake\I18n\FrozenTime $modified
 *
 * @property \App\Model\Entity\DepartmentScheme $department_scheme
 */
class CustomMilestone extends Entity {

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'id' => 1,
        'display_order' => 1,
        'department_scheme_id' => 1,
        'milestone_name' => 1,
        'way_forward' => 1,
        'is_completed' => 1,
        'completion_date' => 1,
        'responsibility' => 1,
        'milestone_status' => 1,
        'created' => 1,
        'modified' => 1,
        'last_modified' => 1,
        'department_scheme' => 1,
    ];

}
