<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * RecordNote Entity
 *
 * @property int $id
 * @property int $department_id
 * @property string $subject
 * @property \Cake\I18n\FrozenDate $meeting_date
 * @property string|null $attachment
 * @property int $created_by
 * @property int $modified_by
 * @property \Cake\I18n\FrozenTime $created
 * @property \Cake\I18n\FrozenTime $modified
 *
 * @property \App\Model\Entity\RecordNoteDetail[] $record_note_details
 */
class RecordNote extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'department_id' => 1,
        'subject' => 1,
        'meeting_date' => 1,
        'attachment' => 1,
        'created_by' => 1,
        'modified_by' => 1,
        'created' => 1,
        'modified' => 1,
        'record_note_details' => 1,
    ];
}
