<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SchemeDistrict Entity
 *
 * @property int $id
 * @property int $department_scheme_id
 * @property int $district_id
 * @property int $department_id
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 * @property int $created_by
 * @property int $modified_by
 *
 * @property \App\Model\Entity\DepartmentScheme $department_scheme
 * @property \App\Model\Entity\District $district
 * @property \App\Model\Entity\Department $department
 */
class SchemeDistrict extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'department_scheme_id' => true,
        'district_id' => true,
        'department_id' => true,
        'created' => true,
        'modified' => true,
        'created_by' => true,
        'modified_by' => true,
        'department_scheme' => true,
        'district' => true,
        'department' => true,
    ];
}
