<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SchemeRequest Entity
 *
 * @property int $id
 * @property int $department_id
 * @property int $scheme_profile_id
 * @property int $user_id
 * @property string $step_name
 * @property string $request_details
 * @property string $status
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 *
 * @property \App\Model\Entity\Department $department
 * @property \App\Model\Entity\SchemeProfile $scheme_profile
 * @property \App\Model\Entity\User $user
 */
class SchemeRequest extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'department_id' => true,
        'department_scheme_id' => true,
        'user_id' => true,
        'step_name' => true,
        'request_details' => true,
        'status' => true,
        'created' => true,
        'modified' => true,
        'department' => true,
        'scheme_profile' => true,
        'user' => true,
    ];
}
