<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * RecordNoteDetails Model
 *
 * @property \App\Model\Table\RecordNotesTable&\Cake\ORM\Association\BelongsTo $RecordNotes
 *
 * @method \App\Model\Entity\RecordNoteDetail newEmptyEntity()
 * @method \App\Model\Entity\RecordNoteDetail newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\RecordNoteDetail get($primaryKey, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\RecordNoteDetail|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\RecordNoteDetail[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class RecordNoteDetailsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('record_note_details');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('RecordNotes', [
            'foreignKey' => 'record_note_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
//        $validator
//            ->integer('id')
//            ->allowEmptyString('id', null, 'create');
//
//        $validator
//            ->scalar('decision_made')
//            ->requirePresence('decision_made', 'create')
//            ->notEmptyString('decision_made');
//
////        $validator
////            ->scalar('progress_made')
////            ->requirePresence('progress_made', 'create')
////            ->notEmptyString('progress_made');
//
//        $validator
//            ->date('timeline')
//            ->requirePresence('timeline', 'create')
//            ->notEmptyDate('timeline');
//
//        $validator
//            ->scalar('notes')
//            ->requirePresence('notes', 'create')
//            ->notEmptyString('notes');
//
//        $validator
//            ->scalar('responsibility')
//            ->maxLength('responsibility', 255)
//            ->requirePresence('responsibility', 'create')
//            ->notEmptyString('responsibility');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['record_note_id'], 'RecordNotes'), ['errorField' => 'record_note_id']);

        return $rules;
    }
}
