<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\AssignChiefDepartment $assignChiefDepartment
 */
$this->assign('title', 'Editing Assign Chief Department');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?=
            $this->Form->postLink(
                    __('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $id], ['confirm' => __('Are you sure you want to delete # {0}?', $id), 'escape' => false]
            )
            ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Assign Chief Departments'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--                        <li><?= $this->Html->link(__('List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="assignChiefDepartments col-lg-6 content">
        <?= $this->Form->create(null, ['class' => 'form-horizontal']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Assign Chief Department') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Chief') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('user_id', ['options' => $users, 'class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Choose Department') . '</label></div>';
//                    echo '<div class="col-sm-7">' . $this->Form->control('department_id', ['options' => $departments, 'class' => 'form-control', 'label' => false]) . '</div>';
                    echo '<div class="col-sm-7 chks ">';
                    echo "<br/><br/>";
                    echo $this->Form->control('parent', ['templates' => [
                            'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="parent" class="input-group-append">
                         All Departments
                    </label></div>'
                        ]
                        , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control checkbox', 'id' => 'parent', 'label' => false]);
                    echo "<br/>";
                    $new_array = [];
                    foreach ($assignChiefDepartments as $dept):
//                         debug();
                        array_push($new_array, $dept->department_id);
                    endforeach;

                    foreach ($departments as $key => $dis):

                        echo $this->Form->control('department_id[]', ['templates' => [
                                'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="dis_' . $key . '" class="input-group-append">
                        ' . ucfirst($dis) . '
                    </label></div>'
                            ]
                            , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control child-chk', 'value' => $key, 'label' => false, in_array($key, $new_array) ? 'checked' : '']);
                    endforeach;

                    echo '</div>';
                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
    <script>

        $(function () {

            $('#parent').on('click', function () {

                if ($('#parent').is(":checked") === true) {
                    $('.child-chk').prop('checked', true);
//                alert('check all please');
                } else {
                    $('.child-chk').prop('checked', false);
//                alert('uncheck all please');

                }
            });

            $('body').on('click', '.child-chk', function () {

                if ($(this).is(':checked') === true) {
//             alert('ahsanali'.includes('a'));
                    var mylabel = $(this).parent().find('label').html().trim();
//               alert(mylabel);
                    $('.checkbox-custom').each(function () {
//                                alert(113);
                        var currentDiv = $(this);
                        var labelText = currentDiv.find("label").html().trim();
//                                alert(labelText);
//alert(mylabel);
//alert(labelText);
//alert()
                        if (labelText.includes(mylabel)) {
//                                    alert(117);
                            currentDiv.find(".child-chk").attr("checked", true);
                        }
                    });
                }
            });
        });
    </script>