<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Comment[]|\Cake\Collection\CollectionInterface $comments
 */
$this->assign('title', 'Listing Comments');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Comment'), ['action' => 'add'], ['escape' => false]) ?></li>
<!--
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('My Comments') ?></h3>
            <a href="<?php echo $this->request->getAttribute("webroot").'admin/comments/exportexcel/';?>" class="btn btn-info pull-right" target="_blank">Export Excel</a>
        </header>

        <div class="comments card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_scheme_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('comments') ?></th>
                        <th scope="col" class="actions" width="100"><?= __('View Replies') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php use Cake\ORM\TableRegistry;
						$Comments = TableRegistry::get('Comments');
						foreach ($comments as $comment): 
							$replies = $Comments->find('all', ['fields' => ['id','comments','created','user_id','u.fname','u.lname','u.users_roles_id'], 'conditions' => ['parent_id' => $comment->id], 'order' => ['Comments.id' => 'desc']])->join(['table' => 'users', 'alias' => 'u', 'type' => 'LEFT', 'conditions' => 'Comments.user_id = u.id'])->all();
							$replies = json_decode(json_encode($replies));?>
                        <tr>
                            <td class="text-right" data-title="Id"><?= $this->Number->format($comment->id) ?></td>
                            <td><?= $comment->has('department') ? ucfirst($comment->department->department_name) : '' ?></td>
                            <td><?= $comment->has('department_scheme') ? $this->Html->link($comment->department_scheme->scheme_code.' - '.$comment->department_scheme->scheme_name, ['controller' => 'DepartmentSchemes', 'action' => 'view', $comment->department_scheme->id]) : '' ?></td>
                            <td><?= nl2br($comment->comments) ?></td>
                            <td class="actions">
                                <a href="#" data-toggle="modal" data-target="#view-replies-<?php echo $comment->id;?>"><i class="fas fa-eye"></i> Replies</a>
                                <div id="view-replies-<?php echo $comment->id;?>" class="modal">
                                    <div class="modal-dialog modal-lg">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h5 class="modal-title">View Replies</h5>
                                          <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>
                                        <div class="modal-body">
                                          <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th scope="col">#</th>
                                                    <th scope="col">Comment</th>
                                                    <th scope="col">Created At</th>
                                                    <th scope="col" class="actions">User</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            <?php if(!empty($replies)){
												foreach($replies as $i => $reply){?>												
                                                <tr>
                                                    <td scope="col"><?= $i + 1?></td>
                                                    <td scope="col"><?= $reply->comments ?></td>
                                                    <td scope="col"><?= date('j<\s\up>S</\s\up> F Y', strtotime($reply->created)); ?></td>
                                                    <td scope="col" class="actions"><?= ucwords($reply->u->fname . ' ' . $reply->u->lname. ' - '.strtoupper($reply->u->users_roles_id)) ?></td>
                                                </tr>	
											<?php }	}else{ ?>
                                            <tr>
                                            	<td colspan="4">No replies yet</td>
                                            </tr>
                                            <?php }?>
                                            </tbody>
                                           </table> 
                                        </div>
                                        <div class="modal-footer"> </div>
                                      </div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-left" data-title="Created"><?= date('j<\s\up>S</\s\up> F Y h:i a', strtotime($comment->created)); ?></td>
                            <td class="actions">
                                <?php $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $comment->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $comment->id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $comment->id], ['confirm' => __('Are you sure you want to delete # {0}?', $comment->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
