<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', 'Adding New Departmental Scheme');
?>
<style>
    .container {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        min-height: 100vh;
        background-color: #ededed;
    }

    .loader {
        max-width: 2rem;
        width: 100%;
        height: auto;
        stroke-linecap: round;
    }

    circle {
        fill: none;
        stroke-width: 3.5;
        -webkit-animation-name: preloader;
        animation-name: preloader;
        -webkit-animation-duration: 3s;
        animation-duration: 3s;
        -webkit-animation-iteration-count: infinite;
        animation-iteration-count: infinite;
        -webkit-animation-timing-function: ease-in-out;
        animation-timing-function: ease-in-out;
        -webkit-transform-origin: 170px 170px;
        transform-origin: 170px 170px;
        will-change: transform;
    }
    circle:nth-of-type(1) {
        stroke-dasharray: 550;
    }
    circle:nth-of-type(2) {
        stroke-dasharray: 500;
    }
    circle:nth-of-type(3) {
        stroke-dasharray: 450;
    }
    circle:nth-of-type(4) {
        stroke-dasharray: 300;
    }
    circle:nth-of-type(1) {
        -webkit-animation-delay: -0.15s;
        animation-delay: -0.15s;
    }
    circle:nth-of-type(2) {
        -webkit-animation-delay: -0.3s;
        animation-delay: -0.3s;
    }
    circle:nth-of-type(3) {
        -webkit-animation-delay: -0.45s;
        -moz-animation-delay:  -0.45s;
        animation-delay: -0.45s;
    }
    circle:nth-of-type(4) {
        -webkit-animation-delay: -0.6s;
        -moz-animation-delay: -0.6s;
        animation-delay: -0.6s;
    }

    @-webkit-keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

    @keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

</style>

<!------ Include the above in your HEAD tag ---------->

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Schemes'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--        <li><?= $this->Html->link(__('List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Add New Department Scheme') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>

                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Choose Department') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('department_id', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><br/><!--/row-->';
//june tak 20 and july mai 21

                    if (date('m') > 5) {
                        $make_year = date('Y');
                    } else {
                        $make_year = date('Y', strtotime("-1 year"));
                    }
                    $year_array = array();
                    for ($i = (int) $make_year; $i >= 2010; $i--):

                        $year_array[$i] = $i;
                    endfor;
//                    debug($year_array);exit;
                    ?>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme # (xxxx-xxxxxx Enter number after the - Hyphen)') . '</label></div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('scheme_code', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('year', ['default' => $make_year, 'options' => $year_array, 'class' => 'form-control', 'label' => false]) . '</div>';
                    ?>
                    <!--                    <div class="col-sm-1">
                                            
                                        </div>-->
                    <div class="col-sm-3">

                        <input class="btn btn-tertiary pull-left" type='button' value='Fetch Details from PCFMS' />
                        <svg class="loader" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 340 340" style="display:none;float:left;">
                            <circle cx="170" cy="170" r="160" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="135" stroke="#404041"/>
                            <circle cx="170" cy="170" r="110" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="85" stroke="#404041"/>
                        </svg>
                        <br/><br/>

                    </div>
                    <div class="col-sm-5"><label>&nbsp;</label></div>
                    <div class="col-sm-7" id="show_error" style="color:red;"></div>
                    <?php
                    echo '</div><!--/row-->';


                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Parent scheme code (if any)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('parent_scheme_code', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Name of the scheme') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_name', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Type') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_type_drop', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => $project_types,'required']) . '</div>';
                    echo '</div><!--/row-->';

                    //scheme profile starts
                    echo $this->Form->hidden('cost_of_scheme', ['id' => 'cost_of_scheme']);

                    echo $this->Form->hidden('expenditure_till_date', ['id' => 'expenditure_till_date']);

                    echo $this->Form->hidden('allocation_for_cfy', ['id' => 'allocation_for_cfy']);
                    echo $this->Form->hidden('release_for_cfy', ['id' => 'release_for_cfy']);
                    echo $this->Form->hidden('progressive_expenditure', ['id' => 'progressive_expenditure']);

                    echo $this->Form->hidden('foreign_funded', ['id' => 'foreign_funded']);

                    echo $this->Form->hidden('geo_coverage', ['id' => 'geo-coverage']);
                    echo $this->Form->hidden('scheme_category', ['id' => 'scheme_category']);

                    //scheme profile ends
                    //step1 starts
                    echo $this->Form->hidden('pc2_required', ['id' => 'pc2_required']);
                    //step1 ends
                    //step2 starts
                    echo $this->Form->hidden('pc1_approved', ['id' => 'pc1_approved']);
                    echo $this->Form->hidden('pc1_approval_date', ['id' => 'pc1_approval_date']);

                    //step2 ends
                    //status starts
                    echo $this->Form->hidden('step1_status', ['id' => 'step1_status']);
                    echo $this->Form->hidden('step2_status', ['id' => 'step2_status']);
                    //status ends


                    echo $this->Form->hidden('scheme_type', ['id' => 'scheme_type']);
                    echo $this->Form->hidden('scheme_start_date', ['id' => 'scheme-start-date']);
                    echo $this->Form->hidden('scheme_end_date', ['id' => 'scheme-end-date']);



                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Start Date<br/>(From the first consideration/review in PDWP)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_start_date_disabled', ['autocomplete' => "off", 'required', 'class' => 'form-control', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme End Date') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_end_date_disabled', ['autocomplete' => "off", 'required', 'class' => 'form-control', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div class="row">
                        <div class="col-sm-5"><label>Responsibility</label></div>
                        <div class="col-sm-7">
                            <input type="text" name="responsibility" plachoder="Responsibility" class="form-control" id="responsibility" />
                        </div>
                    </div>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Proceed'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>

<script>

    $(function () {
        $('#scheme-code').on('blur', function () {
           var scheme_no=$(this).val();
            if ($(this).val().length > 1) {
                $.ajax({
                    type: "GET",
                    url: '<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/checkexisting',
                    data: {scheme_code: scheme_no}, // serializes the form's elements.
//                                data: $('#modal_form').serialize(), // serializes the form's elements.

                    dataType: 'json',
                    success: function (data)
                    {
                        $('#show_error').html('');
                        if (data.id) {
//                        alert(data.user.fname);
                            $('#show_error').html('This scheme is already been added in the portal by "' + data.user.fname + ' ' + data.user.lname + '"');
                        }

                    }
                });
            } else {
                $('#show_error').html('');

            }
        });
        $('.btn-tertiary').on('click', function () {
//                        alert($('#scheme-number').val());
            //            
            //            return false;

            $('.loader').show();
            var scheme_no = $('#scheme-code').val();

            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/checkexisting',
                data: {scheme_code: scheme_no}, // serializes the form's elements.
//                                data: $('#modal_form').serialize(), // serializes the form's elements.

                dataType: 'json',
                success: function (data)
                {
                    $('#show_error').html('');
                    if (data.id) {
//                        alert(data.user.fname);
                        $('#show_error').html('This scheme is already been added in the portal by "' + data.user.fname + ' ' + data.user.lname + '"');
                    }

                }
            });

//            if(str.includes("-")){
//                scheme_no=scheme_no.split('-');
//                scheme_no=scheme_no[1];
//            }

            var dd = {YearID: parseInt($('#year').val()), Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_no};
            var myJSON = JSON.stringify(dd);
//            alert(myJSON);
            $.ajax({
                url: "https://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: myJSON,
                dataType: 'json',
                success: function (data) {
                    $('.loader').hide();
//                    alert(data.CODE);
//
//                    alert(data.Message);
//                    alert(data.Data);
//                    return false;
                    if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {
                        $('#scheme-name').val('').attr('readonly', false);
                        $('#scheme-start-date').val('');
                        $('#scheme-end-date').val('');
                        $('#scheme-start-date-disabled').val('');
                        $('#scheme-end-date-disabled').val('');
                        $('#scheme-type-drop').val('');
                        $('#scheme_type').val('');
                        if (Object.keys(data.Data.SchemeDetail).length) {

                            $.each(data.Data.SchemeDetail, function (key, item) {
//                                            alert(key);
                                $('#scheme-name').val(item.SchemeName).attr('readonly', false);
                                $('#scheme_category').val(item.SchemeCategory);

                                if (item.StartDate) {
                                    var d = new Date(item.StartDate)
                                    var s_month = d.getMonth() + 1;
                                    if (s_month.toString().length === 1) {
                                        s_month = '0' + s_month;
                                    }
                                    var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
                                    $('#scheme-start-date').val(s_date);
                                    $('#scheme-start-date-disabled').val(s_date).attr('disabled', false);
                                } else {
                                    $('#scheme-start-date-disabled').val('').attr('disabled', false);
                                }
                                if (item.EndDate) {
                                    var dd = new Date(item.EndDate);
                                    var e_month = dd.getMonth() + 1;
                                    if (e_month.toString().length === 1) {
                                        e_month = '0' + e_month;
                                    }
//                                alert(e_month.length);
                                    var e_date = dd.getDate() + '-' + e_month + '-' + dd.getFullYear();
                                    $('#scheme-end-date').val(e_date);
                                    $('#scheme-end-date-disabled').val(e_date).attr('disabled', false);
                                } else {
                                    $('#scheme-end-date-disabled').val('').attr('disabled', false);
                                }
//                            alert(item.Type);
                                if (item.Type.trim() === 'KP') {

                                    $('#scheme-type-drop').val('ADP').attr('disabled', false);
                                    $('#scheme_type').val('ADP');
                                    $('#geo-coverage').val('provincial');
                                } else if (item.Type.trim() === 'MA') {
                                    $('#scheme-type-drop').val('ADP').attr('disabled', false);
                                    $('#scheme_type').val('ADP');
                                    $('#geo-coverage').val('merged');
                                } else {
                                    $('#scheme-type-drop').val('AIP').attr('disabled', false);
                                    $('#scheme_type').val('AIP');
                                    $('#geo-coverage').val('settled');
                                }

                                if (item.IsforeignAided === 'No') {

                                    $('#foreign_funded').val('No');
                                } else {

                                    $('#foreign_funded').val('Yes');
                                }

                                //schemeprofile
                                $('#cost_of_scheme').val(item.Cost);
                                $('#allocation_for_cfy').val(item.Allocation);
                                $('#expenditure_till_date').val(item.previousExp);
                                $('#release_for_cfy').val(item.ProgReleases);
                                $('#progressive_expenditure').val(item.ProgressiveExp);
                                //step1
                                if (item.IsPC2 == 'No') {
                                    $('#pc2_required').val('No');
                                    $('#step1_status').val('2');
                                } else {
                                    $('#pc2_required').val('Yes');
                                    $('#step1_status').val('1');

                                }
                                //step2
                                if (item.StatusName == 'Approved' && item.Cost !== 0) {
                                    $('#q2_yes').show('slow');
                                    var d = new Date(item.ApprovedDate)
                                    var s_month = d.getMonth() + 1;
                                    if (s_month.toString().length === 1) {
                                        s_month = '0' + s_month;
                                    }
                                    var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
                                    $('#pc1_approval_date').val(s_date);

                                    $('#pc1_approved').val('Yes');
                                    $('#step2_status').val('2');

                                } else {
                                    $('#pc1_approved').val('No');
                                    $('#step2_status').val('1');


                                }
                            });
                        } else {
                            $('#scheme-name').attr('readonly', false);

                            if (confirm("No scheme found for the mentioned scheme # and year, would you like to proceed anyway?")) {
//                                txt = "You pressed OK!";
                                $('#scheme-name').attr('readonly', false);
                                $('#scheme-type-drop').attr('disabled', false);
                                $('#scheme-start-date-disabled').attr('disabled', false);
                                $('#scheme-end-date-disabled').attr('disabled', false);

                            } else {
//                                txt = "You pressed Cancel!";
//                                $('#scheme-name').attr('readonly', true);
//                                $('#scheme-type-drop').attr('disabled', true);
//                                $('#scheme-start-date-disabled').attr('disabled', true);
//                                $('#scheme-end-date-disabled').attr('disabled', true);


                            }
//                            alert('');
                        }
                    } else {
                        alert(data.CODE + ': ' + data.Message);
                    }
                }, error: function (data) {
                    console.log(data);
                    alert(JSON.stringify(data));
                }
            });
        });
        $('#scheme-start-date-disabled').on('change', function () {
            $('#scheme-start-date').val($(this).val());
        });
        $('#scheme-end-date-disabled').on('change', function () {
            $('#scheme-end-date').val($(this).val());
        });
        $('form').on('submit', function () {
            //            alert($('#scheme-name').val());
            if ($('#scheme-name').val().trim() == '') {
                alert('You must fetch details against scheme # before proceeding.');
                return false;
            }

        });
        $('#scheme-type-drop').on('change', function () {
            $('#scheme_type').val($(this).val());
        });
    });
</script>