<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
   $this->assign('title', 'Editing Department Scheme');

?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
                        <li><?= $this->Form->postLink(
                __('<i class="fas fa-trash"></i> Delete'),
                ['action' => 'delete', $departmentScheme->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape'=>false]
                ) ?></li>
                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape'=>false]) ?></li>
                </ul>
</nav>
<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-6 content">
        <?= $this->Form->create($departmentScheme, ['class'=>'form-horizontal']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Department Scheme') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                                            echo '<div class="row"><div class="col-5"><label>' . __('Department Id') . '</label></div>';
                        echo '<div class="col-5">' .  $this->Form->control('department_id', ['options' => $departments, 'class'=>'form-control' ]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme Status Id') . '</label></div>';
                        echo '<div class="col-5">' .  $this->Form->control('scheme_status_id', ['options' => $schemeStatuses, 'class'=>'form-control' ]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme Name') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('scheme_name', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme Detail') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('scheme_detail', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Active') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('active', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Directive') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('directive', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Cost Of Scheme') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('cost_of_scheme', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Expenditure Till Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('expenditure_till_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Allocation For Cfy') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('allocation_for_cfy', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Release For Cfy') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('release_for_cfy', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Geo Coverage') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('geo_coverage', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme Start Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('scheme_start_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme End Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('scheme_end_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc2 Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc2_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc2 Approved') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc2_approved', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Consultant Hired') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('consultant_hired', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Cons Subt Report') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('cons_subt_report', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc2 Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc2_compl_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Responsible Pc2 Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('responsible_pc2_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc1 Approved') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc1_approved', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc1 Approval Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc1_approval_date', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc1 Stage') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc1_stage', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc1 Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc1_compl_date', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Pc1 Responsible') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('pc1_responsible', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Sne Approved') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('sne_approved', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Through Psc') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_through_psc', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Compl Date Psc') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_compl_date_psc', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Responsible Psc') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('responsible_psc', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Through Internal Posting') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_through_internal_posting', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Compl Date Internal Posting') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_compl_date_internal_posting', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Responsible Internal Posting') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('responsible_internal_posting', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Through Market') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_through_market', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Posting Though Market Media') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('posting_though_market_media', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Entries Recorded') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_entries_recorded', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Scrutiny Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_scrutiny_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Intervies Cond') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_intervies_cond', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Appoint Letter Issues') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_appoint_letter_issues', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_compl_date', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Hiring Market Respons Person') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('hiring_market_respons_person', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Acquisition Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_acquisition_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Identified') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_identified', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Section4 Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_section4_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Section6 Comp') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_section6_comp', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Possision Taken Over') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_possision_taken_over', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Award Been Issued') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_award_been_issued', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Payment Made') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_payment_made', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Acquisition Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_acquisition_compl_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Land Acquisition Responsible') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('land_acquisition_responsible', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Tender Advertised') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_tender_advertised', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Bidding Complete') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_bidding_complete', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Po Issued') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_po_issued', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Delivery Physical Verification Done') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_delivery_physical_verification_done', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Distribution Equipments') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_distribution_equipments', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Evidence Of Distribution') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_evidence_of_distribution', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_compl_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Goods Responsible') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_goods_responsible', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Tender Advertised') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_tender_advertised', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Tech Finance Proposal Received') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_tech_finance_proposal_received', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Evaluation Process Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_evaluation_process_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Contract Awarded') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_contract_awarded', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Status') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_status', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_compl_date', ['empty' => true]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Proc Services Responsible') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('proc_services_responsible', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Cons Civil Work Required') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('cons_civil_work_required', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Carried By Civil Works') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_carried_by_civil_works', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Commisioned Privately') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_commisioned_privately', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Tender Advertised') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_tender_advertised', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Bidding Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_bidding_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Order Issued') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_order_issued', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Is Work Begun') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('is_work_begun', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Level Of Work Compl') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('level_of_work_compl', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Cons Civil Compl Date') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('cons_civil_compl_date', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Cons Civil Responsible') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('cons_civil_responsible', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Comments') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('comments', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Scheme File') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('scheme_file', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Created By') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('created_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Modified By') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('modified_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-5"><label>' . __('Deleted') . '</label></div>';
                        echo '<div class="col-7">' . $this->Form->control('deleted', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                            ?>
                        </fieldset>

                    </div><!--card-body-->

                    <footer class="card-footer text-right">
                        <?= $this->Form->button(__('Submit'), ['class'=>'btn btn-primary']) ?>
                        <?= $this->Form->end() ?>
                    </footer>

                </section>
            </div>