<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>
<style>
    .container {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        min-height: 100vh;
        background-color: #ededed;
    }

    .loader {
        max-width: 2rem;
        width: 100%;
        height: auto;
        stroke-linecap: round;
    }

    circle {
        fill: none;
        stroke-width: 3.5;
        -webkit-animation-name: preloader;
        animation-name: preloader;
        -webkit-animation-duration: 3s;
        animation-duration: 3s;
        -webkit-animation-iteration-count: infinite;
        animation-iteration-count: infinite;
        -webkit-animation-timing-function: ease-in-out;
        animation-timing-function: ease-in-out;
        -webkit-transform-origin: 170px 170px;
        transform-origin: 170px 170px;
        will-change: transform;
    }
    circle:nth-of-type(1) {
        stroke-dasharray: 550;
    }
    circle:nth-of-type(2) {
        stroke-dasharray: 500;
    }
    circle:nth-of-type(3) {
        stroke-dasharray: 450;
    }
    circle:nth-of-type(4) {
        stroke-dasharray: 300;
    }
    circle:nth-of-type(1) {
        -webkit-animation-delay: -0.15s;
        animation-delay: -0.15s;
    }
    circle:nth-of-type(2) {
        -webkit-animation-delay: -0.3s;
        animation-delay: -0.3s;
    }
    circle:nth-of-type(3) {
        -webkit-animation-delay: -0.45s;
        -moz-animation-delay:  -0.45s;
        animation-delay: -0.45s;
    }
    circle:nth-of-type(4) {
        -webkit-animation-delay: -0.6s;
        -moz-animation-delay: -0.6s;
        animation-delay: -0.6s;
    }

    @-webkit-keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

    @keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

</style>
<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
//june tak 20 and july mai 21

                    if (date('m') > 6) {
                        $make_year = date('Y');
                    } else {
                        $make_year = date('Y', strtotime("-1 year"));
                    }
                    $year_array = array();
                    for ($i = $make_year; $i >= 2010; $i--):

                        $year_array[$i] = $i;
                    endfor;
                    ?>
                    <?php
//                    debug($departmentScheme->scheme_code);
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme # (xxxx-xxxxxx Enter number after the - Hyphen)') . '</label></div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('scheme_code', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('year', ['options' => $year_array, 'class' => 'form-control', 'label' => false]) . '</div>';
                    ?>
                    <!--                    <div class="col-sm-1">
                                            
                                        </div>-->
                    <div class="col-sm-3">

                        <input class="btn btn-tertiary pull-left" type='button' value='Fetch Details from PCFMS' />
                        <svg class="loader" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 340 340" style="display:none;float:left;">
                            <circle cx="170" cy="170" r="160" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="135" stroke="#404041"/>
                            <circle cx="170" cy="170" r="110" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="85" stroke="#404041"/>
                        </svg>
                        <br/><br/>
                    </div>
                    <?php
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Parent scheme code (if any)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('parent_scheme_code', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Name of the scheme') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_name', ['class' => 'form-control', 'label' => false, 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Type') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_type_drop', ['class' => 'form-control', 'label' => false, 'value' => $departmentScheme->scheme_type, 'empty' => 'Choose', 'options' => $project_types]) . '</div>';
                    echo '</div><!--/row-->';

                    echo $this->Form->hidden('scheme_type', ['id' => 'scheme_type']);


//                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Detail') . '</label></div>';
//                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_detail', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//                    echo '<div class="row"><div class="col-sm-5"><br/><label>' . __('Active') . '</label></div>';
//                    echo '<div class="col-sm-7"><br/>' . $this->Form->control('active', ['class' => 'form-control', 'label' => false,'type'=>'checkbox','checked']) . '</div>';
//                    echo '</div><!--/row-->';
//                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the scheme a PM/CM directive? (Mega Project)') . '</label></div>';
//                    echo '<div class="col-sm-7">' . $this->Form->control('directive', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
//                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the scheme Foreign Funded?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('foreign_funded_drop', ['class' => 'form-control', 'label' => false, 'value' => $departmentScheme->foreign_funded, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the scheme PPP (public private parternship)?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('is_ppp', ['class' => 'form-control', 'label' => false, 'value' => $departmentScheme->is_ppp, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';

                    echo $this->Form->hidden('foreign_funded', ['id' => 'foreign_funded']);

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Total cost of the scheme (in Rs. millions)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('cost_of_scheme', ['class' => 'form-control', 'label' => false, 'required', 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Previous Expenditure (in Rs. millions)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('expenditure_till_date', ['class' => 'form-control', 'label' => false, 'required', 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Progressive Expenditure  (in Rs. millions)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('progressive_expenditure', ['class' => 'form-control', 'label' => false, 'required', 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Allocation for current financial year (in Rs. millions)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('allocation_for_cfy', ['class' => 'form-control', 'label' => false, 'required', 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Release of funds in current financial year (in Rs. millions)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('release_for_cfy', ['class' => 'form-control', 'label' => false, 'required', 'readonlyz']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Geographical coverage of the scheme') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('geo_coverage', ['empty' => 'Choose', 'class' => 'form-control', 'required', 'label' => false, 'options' => ['provincial' => 'Provincial', 'settled' => 'Settled', 'merged' => 'Merged Areas']]) . '</div>';
                    echo '</div><!--/row-->';

                    echo $this->Form->hidden('scheme_start_date', ['id' => 'scheme-start-date']);
                    echo $this->Form->hidden('scheme_end_date', ['id' => 'scheme-end-date']);



                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Start Date<br/>(From the first consideration/review in PDWP)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_start_date_disabled', ['autocomplete' => "off", 'disabledz', 'value' => date('d-m-Y', strtotime($departmentScheme->scheme_start_date)), 'class' => 'form-control', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme End Date') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('scheme_end_date_disabled', ['autocomplete' => "off", 'disabledz', 'value' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date)), 'class' => 'form-control', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Issue with the scheme (if any)') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('issues_list', ['plachoder'=>'type N/A if no issue','required','class' => 'form-control', 'label' => false, 'type' => 'textarea']) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';   ?>
                    <?php
                    if ($get_Request) {
                        echo 'Request Date Changes: ' . $get_Request->request_details;
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>

<script>

    $(function () {
//        alert(<?= $departmentScheme->scheme_code; ?>);
//        var scheme_code = '<?= $departmentScheme->scheme_code; ?>';
//        var year =<?= $departmentScheme->year; ?>
//
////            alert(scheme_code);
//
//        var dd = {YearID: year, Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_code};
//        var myJSON = JSON.stringify(dd);
//        $.ajax({
//            url: "http://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
//            type: 'POST',
//            contentType: 'application/json; charset=utf-8',
//            data: myJSON,
//            dataType: 'json',
//            success: function (data) {
//                $('.loader').hide();
//
//                if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {
//                    if (Object.keys(data.Data.SchemeDetail).length) {
//
//                        $.each(data.Data.SchemeDetail, function (key, item) {
//
//                            $('#scheme-name').val(item.SchemeName);
//                            if (item.StartDate) {
//                                var d = new Date(item.StartDate)
//                                var s_month = d.getMonth() + 1;
//                                if (s_month.toString().length === 1) {
//                                    s_month = '0' + s_month;
//                                }
//                                var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
//                                $('#scheme-start-date').val(s_date);
//                                $('#scheme-start-date-disabled').val(s_date).attr('disabled', true);
//
//                            } else {
//                                $('#scheme-start-date-disabled').attr('disabled', false);
//
//                            }
//                            if (item.EndDate) {
//                                var dd = new Date(item.EndDate);
//                                var e_month = dd.getMonth() + 1;
//                                if (e_month.toString().length === 1) {
//                                    e_month = '0' + e_month;
//                                }
////                                alert(e_month.length);
//                                var e_date = dd.getDate() + '-' + e_month + '-' + dd.getFullYear();
//                                $('#scheme-end-date').val(e_date);
//                                $('#scheme-end-date-disabled').val(e_date).attr('disabled', true);
//
//                            } else {
//                                $('#scheme-end-date-disabled').attr('disabled', false);
//
//                            }
//                            if (item.Type.trim() === 'KP') {
//
//                                $('#scheme-type-drop').val('ADP').attr('disabled', true);
//                                $('#scheme_type').val('ADP');
//                                $('#geo-coverage').val('provincial');
//                            } else if (item.Type.trim() === 'MA') {
//                                $('#scheme-type-drop').val('ADP').attr('disabled', true);
//                                $('#scheme_type').val('ADP');
//                                $('#geo-coverage').val('merged');
//                            } else {
//                                $('#scheme-type-drop').val('AIP').attr('disabled', true);
//                                $('#scheme_type').val('AIP');
//                                $('#geo-coverage').val('settled');
//                            }
//                            $('#cost-of-scheme').val(item.Cost);
//                            $('#allocation-for-cfy').val(item.Allocation);
//                            $('#expenditure-till-date').val(item.previousExp);
//                            $('#progressive-expenditure').val(item.ProgressiveExp.toFixed(3));
//
//                            $('#release-for-cfy').val(item.ProgReleases);
//
//                            if (item.IsforeignAided === 'No') {
//                                $('#foreign-funded-drop').val('No').attr('disabled', true);
//                                $('#foreign_funded').val('No');
//                            } else {
//                                $('#foreign-funded-drop').val('Yes').attr('disabled', true);
//                                $('#foreign_funded').val('Yes');
//                            }
//
//                        });
//                    } else {
//                        $('input').attr('readonly', false);
//                        $('input').attr('disabled', false);
//
//                    }
//                } else {
//                    alert(data.CODE + ': ' + data.Message);
//                }
//            }
//        });

        $('#scheme-start-date-disabled').on('change', function () {
            $('#scheme-start-date').val($(this).val());
        });
        $('#scheme-end-date-disabled').on('change', function () {
            $('#scheme-end-date').val($(this).val());
        });

        $('#scheme-type-drop').on('change', function () {
            $('#scheme_type').val($(this).val());
        });

        $('#foreign-funded-drop').on('change', function () {
            $('#foreign_funded').val($(this).val());
        });

        //ON CLICK
        $('.btn-tertiary').on('click', function () {
            //            alert($('#scheme-number').val());
            //            
            //            return false;

            $('.loader').show();
            var scheme_no = $('#scheme-code').val();
//            if(str.includes("-")){
//                scheme_no=scheme_no.split('-');
//                scheme_no=scheme_no[1];
//            }

            var dd = {YearID: parseInt($('#year').val()), Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_no};
            var myJSON = JSON.stringify(dd);
//            alert(myJSON);
            $.ajax({
                url: "https://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: myJSON,
                dataType: 'json',
                success: function (data) {
                    $('.loader').hide();
//                    alert(data.CODE);
//
//                    alert(data.Message);
//                    alert(data.Data);
//                    return false;
                    if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {
                        if (Object.keys(data.Data.SchemeDetail).length) {

                            $.each(data.Data.SchemeDetail, function (key, item) {

                                $('#scheme-name').val(item.SchemeName).attr('readonly', false);
                                if (item.StartDate) {
                                    var d = new Date(item.StartDate)
                                    var s_month = d.getMonth() + 1;
                                    if (s_month.toString().length === 1) {
                                        s_month = '0' + s_month;
                                    }
                                    var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
                                    $('#scheme-start-date').val(s_date);
                                    $('#scheme-start-date-disabled').val(s_date).attr('disabled', false);

                                }
                                if (item.EndDate) {
                                    var dd = new Date(item.EndDate);
                                    var e_month = dd.getMonth() + 1;
                                    if (e_month.toString().length === 1) {
                                        e_month = '0' + e_month;
                                    }
//                                alert(e_month.length);
                                    var e_date = dd.getDate() + '-' + e_month + '-' + dd.getFullYear();
                                    $('#scheme-end-date').val(e_date);
                                    $('#scheme-end-date-disabled').val(e_date).attr('disabled', false);

                                }
                                if (item.Type.trim() === 'KP') {

                                    $('#scheme-type-drop').val('ADP').attr('disabled', false);
                                    $('#scheme_type').val('ADP');
                                    $('#geo-coverage').val('provincial');
                                } else if (item.Type.trim() === 'MA') {
                                    $('#scheme-type-drop').val('ADP').attr('disabled', false);
                                    $('#scheme_type').val('ADP');
                                    $('#geo-coverage').val('merged');
                                } else {
                                    $('#scheme-type-drop').val('AIP').attr('disabled', false);
                                    $('#scheme_type').val('AIP');
                                    $('#geo-coverage').val('settled');
                                }
                                $('#cost-of-scheme').val(item.Cost).attr('readonly', false);
                                $('#allocation-for-cfy').val(item.Allocation).attr('readonly', false);
                                $('#expenditure-till-date').val(item.previousExp).attr('readonly', false);
                                $('#progressive-expenditure').val(item.ProgressiveExp.toFixed(3)).attr('readonly', false);
                                $('#release-for-cfy').val(item.ProgReleases).attr('readonly', false);

                                if (item.IsforeignAided === 'No') {
                                    $('#foreign-funded-drop').val('No').attr('disabled', false);
                                    $('#foreign_funded').val('No');
                                } else {
                                    $('#foreign-funded-drop').val('Yes').attr('disabled', false);
                                    $('#foreign_funded').val('Yes');
                                }
                            });
                        } else {

                            if (confirm("No scheme found for the mentioned scheme # and year, would you like to proceed anyway?")) {
//                                txt = "You pressed OK!";
                                $('input').attr('readonly', false);
                                $('input').attr('disabled', false);
                                $('select').attr('readonly', false);
                                $('select').attr('disabled', false);

                            } else {
//                                txt = "You pressed Cancel!";
//                                $('#scheme-name').attr('readonly', true);
//                                $('#scheme-type-drop').attr('disabled', true);
//                                $('#scheme-start-date-disabled').attr('disabled', true);
//                                $('#scheme-end-date-disabled').attr('disabled', true);


                            }
                        }
                    } else {
                        alert(data.CODE + ': ' + data.Message);
                    }
                }
            });
        });

    });

</script>