<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is construction/civil work required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('cons_civil_work_required', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id='q7' style="display:<?= ($departmentScheme->cons_civil_work_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                        <?php
                        $main_required = ($departmentScheme->hiring_required == 'Yes') ? 'required' : '';


                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the work to be carried out by C & W?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('is_work_carried_by_civil_works', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $main_required]) . '</div>';
                        echo '</div><!--/row-->';
                        ?>


                        <div id="other_agency" style="display:<?= ($departmentScheme->is_work_carried_by_civil_works == 'No') ? 'block' : 'none'; ?>;margin:20px;">
                            <?php
                            $other_agency = ($departmentScheme->is_work_carried_by_civil_works == 'No') ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the construction commissioned through other agency?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('is_work_commisioned_privately', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $other_agency]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                        </div>
                        <div id='q7_3only' style="display:<?= ($departmentScheme->is_work_commisioned_privately == 'Yes' && $departmentScheme->is_work_carried_by_civil_works == 'No') ? 'block' : 'none'; ?>;margin:20px;">
                            <?php
                            $q7_3_required = ($departmentScheme->is_work_commisioned_privately == 'Yes') ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Will the agency for civil works hired through Single sourcing/ Open Tendering?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('cons_civil_private_type', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['single_source' => 'Single Source', 'open_tender' => 'Open Tendering'], $q7_3_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>

                            <div id='q7_3only_tender' style="display:<?= ($departmentScheme->cons_civil_private_type == 'open_tender') ? 'block' : 'none'; ?>;margin:20px;">
                                <?php
                                $q7_3_onlytender_required = ($departmentScheme->cons_civil_private_type == 'open_tender') ? 'required' : '';
// in social and traditional media
                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the tender been advertised?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('is_work_tender_advertised', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q7_3_onlytender_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the bidding and selection process complete?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('is_work_bidding_compl', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q7_3_onlytender_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Have the work orders been issued?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('is_work_order_issued', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q7_3_onlytender_required]) . '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>
                        </div>
                        <div id='q7_23both' style="display:<?= ($departmentScheme->is_work_carried_by_civil_works == 'Yes' || $departmentScheme->is_work_commisioned_privately == 'Yes' ) ? 'block' : 'none'; ?>;margin:20px;">
                            <?php
                            $both_required = ($departmentScheme->is_work_carried_by_civil_works == 'Yes' || $departmentScheme->is_work_commisioned_privately == 'Yes' ) ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the work begun?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('is_work_begun', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $both_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>

                            <div id='work_begun' style="display:<?= ($departmentScheme->is_work_begun == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                                <?php
                                $begun_required = ($departmentScheme->is_work_begun == 'Yes') ? 'required' : '';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the level of work completed so far?') . '</label></div>';
                                $prog = array();
                                for ($i = 0; $i <= 100;):
//                                    array_push($prog, $i);
                                    $prog[$i] = $i;

                                    $i = $i + 5;
                                endfor;


                                echo '<div class="col-sm-7">' . $this->Form->control('level_of_work_compl', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => $prog, $begun_required]) . '</div>';
                                echo '</div><!--/row-->';
                                ?>

                            </div>
                            <?php
                            echo "<br/><br/>";

                            echo $this->Form->hidden('cons_civil_old_compl_date', ['id' => 'cons_civil_old_compl_date', 'value' => date('Y-m-d', strtotime($departmentScheme->cons_civil_compl_date))]);

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Expected completion date for construction/civil works?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('cons_civil_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $both_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->cons_civil_compl_date) ? date('d-m-Y', strtotime($departmentScheme->cons_civil_compl_date)) : '']) . '</div>';
                            echo '</div><!--/row-->';
                            $departments['Other'] = 'Other';
                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the construction/civil works process?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('cons_civil_responsible', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                            echo '</div><!--/row-->';

                            echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('designation_step7', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter details of responsible person/company']) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                        </div>
                        <?php
//                        echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
//                        echo '<div class="col-sm-7">' . $this->Form->control('designation_step7', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
//                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label><br/><small>(You can add your weekly updates here in this section too). </small></div>';

                        echo '<div class="col-sm-7">' . $this->Form->control('step7_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step6/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';   ?>
                    <?php
                    if ($get_Request) {
                        echo 'Request Date Changes: ' . $get_Request->request_details;
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {
        //q7
        $('body').on('change', '#cons-civil-work-required', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q7').show('slow');

                $('#is-work-carried-by-civil-works').attr('required', true);
                $('#is-work-commisioned-privately').attr('required', true);
                $('#cons-civil-compl-date').attr('required', true);
                $('#cons-civil-responsible').attr('required', true);
            } else {
                $('#q7').find('input').attr('required', false);
                $('#q7').find('select').attr('required', false);
                $('#q7').find('input').val('');
                $('#q7').find('select').val('');


                $('#q7').hide('slow');
                $('#q7_23both').hide('slow');
                $('#q7_3only').hide('slow');


            }
            $('#designation-step7').attr('required', false);

        });
//            q7_2
        $('body').on('change', '#is-work-carried-by-civil-works', function () {
            if ($(this).val() == 'Yes') {

// || $('#is-work-commisioned-privately').val() == 'Yes'
                $('#q7_23both').show('slow');

                $('#q7_23both').find('input').attr('required', true);
                $('#q7_23both').find('select').attr('required', true);
                $('#other_agency').hide('slow')
                $('#other_agency').find('select').attr('required', false);
                $('#is-work-commisioned-privately').val('No').trigger('change');

                $('#q7_3only').hide('slow');
                $('#q7_3only').find('select').attr('required', false);

                $('#cons-civil-responsible').val($('#cons-civil-responsible option').filter(function () {
                    return $(this).html() == "C &amp; W";
                }).val());


            } else if ($(this).val() == 'No') {

                $('#q7_23both').find('input').attr('required', false);
                $('#q7_23both').find('select').attr('required', false);
                $('#q7_23both').find('input').val('');
                $('#q7_23both').find('select').val('');

                $('#q7_23both').hide('slow');
                $('#other_agency').show('slow')
                $('#other_agency').find('select').attr('required', true);

                $('#is-work-commisioned-privately').val('Yes').trigger('change');

                $('#q7_3only').find('select').val('');
                $('#q7_3only').find('input').val('');
                $('#q7_3only_tender').hide();
                $('#work_begun').hide();

                $('#cons-civil-responsible').val($('#cons-civil-responsible option').filter(function () {
                    return $(this).html() == "Other";
                }).val());


            } else {
                $('#other_agency').hide().find('input, select').attr('required', false);
                $('#q7_3only').hide().find('input, select').attr('required', false);
                $('#q7_23both').hide().find('input, select').attr('required', false);

            }
            $('#designation-step7').attr('required', false);

        });
        //            q7_3
        $('body').on('change', '#is-work-commisioned-privately', function () {
            if ($(this).val() == 'Yes' || $('#is-work-carried-by-civil-works').val() == 'Yes') {
                $('#q7_23both').show('slow');

                $('#q7_23both').find('input').attr('required', true);
                $('#q7_23both').find('select').attr('required', true);
            } else {
                $('#q7_23both').find('input').attr('required', false);
                $('#q7_23both').find('select').attr('required', false);
                $('#q7_23both').find('input').val('');
                $('#q7_23both').find('select').val('');

                $('#q7_23both').hide('slow');

            }

            if ($(this).val() == 'Yes') {
                $('#q7_3only').show('slow');

                $('#q7_3only').find('input').attr('required', true);
                $('#q7_3only').find('select').attr('required', true);
            } else {
                $('#q7_3only').find('input').attr('required', false);
                $('#q7_3only').find('select').attr('required', false);
                $('#q7_3only').find('input').val('');
                $('#q7_3only').find('select').val('');

                $('#q7_3only').hide('slow');

            }
            $('#designation-step7').attr('required', false);

        });

        $('body').on('change', '#cons-civil-private-type', function () {
            if ($(this).val() == 'open_tender') {

                $('#q7_3only_tender').show('slow');
                $('#q7_3only_tender').find('input').attr('required', true);
                $('#q7_3only_tender').find('select').attr('required', true);
            } else {
                $('#q7_3only_tender').find('input').attr('required', false);
                $('#q7_3only_tender').find('select').attr('required', false);
                $('#q7_3only_tender').find('input').val('');
                $('#q7_3only_tender').find('select').val('');

                $('#q7_3only_tender').hide('slow');
            }
            $('#designation-step7').attr('required', false);

        });

        $('body').on('change', '#is-work-begun', function () {
            if ($(this).val() == 'Yes') {
                $('#work_begun').show('slow');

                $('#work_begun').find('input').attr('required', true);
                $('#work_begun').find('select').attr('required', true);
            } else {
                $('#work_begun').find('input').attr('required', false);
                $('#work_begun').find('select').attr('required', false);
                $('#work_begun').find('input').val('');
                $('#work_begun').find('select').val('');

                $('#work_begun').hide('slow');

            }
            $('#designation-step7').attr('required', false);

        });

//        $('body').on('change', '#cons-civil-compl-date', function () {
//
//            if ($('#cons_civil_old_compl_date').val() !== '1970-01-01' && $('#cons_civil_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#cons_civil_old_compl_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });

        $('form').on('submit', function () {
//             alert();
            if ($('#cons-civil-work-required').val() == 'Yes' && $('#is-work-carried-by-civil-works').val() == 'No' && $('#is-work-commisioned-privately').val() == 'No') {
                alert('Warning: You must choose 1 construction method, else you can not proceed.');
                return false;
            }

        });

    });
</script>
