<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    $p_checked = '';
                    if (count($districts) == count($choosen_districts)) {
                        $p_checked = 'checked';
                    }

                    echo '<div class="row"><div class="col-sm-3"><label >' . __('Relevent ' . ucfirst($departmentScheme->geo_coverage) . ' Districts') . '</label></div>';
                    echo '<div class="col-sm-9 chks ">';

                    echo $this->Form->control('parent', ['templates' => [
                            'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="parent" class="input-group-append">
                         All Districts
                    </label></div>'
                        ]
                        , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control checkbox', 'id' => 'parent', 'label' => false, $p_checked]);
                    echo "<br/>";
                    foreach ($districts as $key => $dis):

                        echo $this->Form->control('disid[]', ['templates' => [
                                'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="dis_' . $key . '" class="input-group-append">
                        ' . ucfirst($dis) . '
                    </label></div>'
                            ]
                            , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control child-chk', 'value' => $key, 'label' => false, 'id' => 'dis_' . $key, in_array($key, $choosen_districts) ? 'checked' : '']);
                    endforeach;

                    echo '</div>';
                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/schemeprofile/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>

                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {

        var scheme_code =<?= $departmentScheme->scheme_code; ?>;
        var year =<?= $departmentScheme->year; ?>

//            alert($('#cost-of-scheme').val());

        var dd = {YearID: year, Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_code};
        var myJSON = JSON.stringify(dd);
        $.ajax({
            url: "https://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
            type: 'POST',
            contentType: 'application/json; charset=utf-8',
            data: myJSON,
            dataType: 'json',
            success: function (data) {
                $('.loader').hide();

                if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {

                    $.each(data.Data.SchemeDetail, function (key, item) {
                        if (item.DistrictName !== 'Provincial') {
//                            alert(item.DistrictName);
                            $('.checkbox-custom').each(function () {
//                                alert(113);
                                var currentDiv = $(this);
                                var labelText = currentDiv.find("label").html();
//                                alert(labelText);
//alert(typeof labelText);
//alert(typeof item.DistrictName);
                                if (labelText.trim() === item.DistrictName) {
//                                    alert(117);
                                    currentDiv.find(".child-chk").attr("checked", true);
                                }
                            });
//                            $('#pc1-responsible').val($('#pc1-responsible option').filter(function () {
//                                return $(this).html() == "Planning &amp; Development";
//                            }).val());
                        }

                    });

                } else {
                    alert(data.CODE + ': ' + data.Message);
                }
            }
        });

        $('#parent').on('click', function () {

            if ($('#parent').is(":checked") === true) {
                $('.child-chk').prop('checked', true);
//                alert('check all please');
            } else {
                $('.child-chk').prop('checked', false);
//                alert('uncheck all please');

            }
        });

        $('body').on('click', '.child-chk', function () {
           
            if ($(this).is(':checked') === true) {
//             alert('ahsanali'.includes('a'));
               var mylabel= $(this).parent().find('label').html().trim();
//               alert(mylabel);
                $('.checkbox-custom').each(function () {
//                                alert(113);
                    var currentDiv = $(this);
                    var labelText = currentDiv.find("label").html().trim();
//                                alert(labelText);
//alert(mylabel);
//alert(labelText);
//alert()
                    if (labelText.includes(mylabel)) {
//                                    alert(117);
                        currentDiv.find(".child-chk").attr("checked", true);
                    }
                });
            }
        });
    });
</script>