<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is land acquisition required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('land_acquisition_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q4" style="display:<?= ($departmentScheme->land_acquisition_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                        <?php
                        $required = ($departmentScheme->land_acquisition_required == 'Yes') ? 'required' : '';


                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the land been identified?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_identified', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is Section 4 complete?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_section4_compl', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is Section 6 complete?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_section6_comp', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the possession of the land been taken over?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_possision_taken_over', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the award been issued?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_award_been_issued', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the payment been made?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_payment_made', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

//                        echo $this->Form->hidden('land_acquisition_old_compl_date', ['id' => 'land_acquisition_old_compl_date', 'value' => date('Y-m-d', strtotime($departmentScheme->land_acquisition_compl_date))]);


                        echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the expected completion date for land acquisition?') . '</label></div>';
                        echo '<div class="col-sm-7">';
                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->land_acquisition_compl_date && !in_array($myUser->users_roles_id, ['admin', 'sub-admin'])) {
                            if ($myUser->users_roles_id == 'pm') { //cant do anything
                                //display old date
                                echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->land_acquisition_compl_date));
                            } else { //cpo
                                //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                    //cpo cant do anything too-display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->land_acquisition_compl_date));
                                } else {
                                    //cpo can do and show fields again
                                    echo $this->Form->control('land_acquisition_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->land_acquisition_compl_date) ? date('d-m-Y', strtotime($departmentScheme->land_acquisition_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
                            }
                        } else {
                            //show fields to change
                            echo $this->Form->control('land_acquisition_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->land_acquisition_compl_date) ? date('d-m-Y', strtotime($departmentScheme->land_acquisition_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                        }

//                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->land_acquisition_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->land_acquisition_compl_date));
//                        } else {
//                            echo $this->Form->control('land_acquisition_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->land_acquisition_compl_date) ? date('d-m-Y', strtotime($departmentScheme->land_acquisition_compl_date)) : '']);
//                        }
                        echo '</div>';
                        echo '</div><!--/row-->';

                        $departments['Other'] = 'Other';
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the land acquisition process?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('land_acquisition_responsible', ['class' => 'form-control', 'label' => false, $required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('designation_step4', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label><br/><small>(You can add your weekly updates here in this section too). </small></div>';
                        echo $this->Form->control('step4_old_remarks', ['value' => $departmentScheme->step4_remarks, 'type' => 'hidden']);

                        echo '<div class="col-sm-7">' . $this->Form->control('step4_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step3/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';       ?>
                    <?php
//                    if ($departmentScheme->locked && $departmentScheme->land_acquisition_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
//                        if ($schemeRequests == 0) {
                    ?>
                    <!--<a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the Land Acquisition Process?</a>-->
                    <?php
//                        } else {
//
//                            echo "Request already pending to change date.";
//                        }
//                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {


        //q4
        $('body').on('change', '#land-acquisition-required', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q4').show('slow');
                $('#q4').find('input').attr('required', true);
                $('#q4').find('select').attr('required', true);
                $('#land-acquisition-responsible').val(<?= $departmentScheme->department_id ?>);

            } else {

                $('#q4').find('input').attr('required', false);
                $('#q4').find('select').attr('required', false);
                $('#q4').find('input').val('');
                $('#q4').find('select').val('');


                $('#q4').hide('slow');
            }
            $('#designation-step4').attr('required', false);

        });

//        $('body').on('change', '#land-acquisition-compl-date', function () {
//
//            if ($('#land_acquisition_old_compl_date').val() !== '1970-01-01' && $('#land_acquisition_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#land_acquisition_old_compl_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });
    });
</script>
