<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Department $department
 */
$this->assign('title', 'Editing Department');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?=
            $this->Form->postLink(
                    __('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $department->id], ['confirm' => __('Are you sure you want to delete # {0}?', $department->department_name), 'escape' => false]
            )
            ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="departments col-lg-6 content">
        <?= $this->Form->create($department, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Department') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-5"><label>' . __('Department Name') . '</label></div>';
                    echo '<div class="col-7">' . $this->Form->control('department_name', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-5"><label>' . __('Department Logo') . '</label></div>';
                    echo '<div class="col-7">';
                    if (file_exists(WWW_ROOT . 'img/departments/' . $department->department_logo) && !empty($department->department_logo)) {

                        echo 'Existing Logo: <img src="' . $this->request->getAttribute("webroot") . 'img/departments/' . $department->department_logo . '" style="height:50px">';
                        echo '&nbsp;&nbsp;<a id="delete_evidence" style="color:red;" href="#"><i aria-hidden="true" class="fas fa-trash"></i></a>';
                    }
                    echo $this->Form->control('department_logo', ['class' => 'form-control', 'label' => false, 'type' => 'file']);
                    echo '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-5"><label>' . __('Department Responsibilities') . '</label></div>';
                    echo '<div class="col-7">' . $this->Form->control('department_responsibilities', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-5"><br/><label>' . __('Active') . '</label></div>';
                    echo '<div class="col-7"><br/>' . $this->Form->control('active', ['class' => 'form-control', 'label' => false, 'type' => 'checkbox']) . '</div>';
                    echo '</div><!--/row-->';

//                    echo '<div class="row"><div class="col-5"><label>' . __('Created By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('created_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Modified By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('modified_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Deleted') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('deleted', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
    <script>

        $(function () {

            $('body').on('click', '#delete_evidence', function () {
                if (confirm('Are you sure want to delete?')) {
                    window.location.href = '<?php echo $this->request->getAttribute("webroot"); ?>admin/departments/remove/<?php echo $department->id; ?>';
                                }
                            });
                        });
    </script>