<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Department[]|\Cake\Collection\CollectionInterface $departments
 */
$this->assign('title', 'Listing Departments');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <!--<li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['action' => 'add'], ['escape' => false]) ?></li>-->

<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>-->
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Departments') ?></h3>
        </header>

        <div class="departments card-body content">
            <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

            <div class="row">

                <div class="col-sm-10">
                    <?= $this->Form->control('name', ['placeholder' => 'Search by department name', 'class' => 'form-control', 'value' => isset($_GET['name']) ? $_GET['name'] : '']); ?>
                    <br/>
                </div>


                <div class="col-sm-2">
                    <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary', 'style' => 'margin-top:30px;']) ?>
                    <br/>
                </div>

            </div>
            <?= $this->Form->end() ?>
            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= $this->Paginator->sort('id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('department_name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_logo') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('active') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('department_responsibilities') ?></th>
<!--                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                       <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                       <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                       <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                       <th scope="col"><?= $this->Paginator->sort('deleted') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($departments as $department):
//                        debug();
//                    exit;
                        ?>
                        <tr>
                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($department->id) ?></td>-->
                            <td class="text-left" data-title="Department Name"><?= h($department->department_name) ?></td>
                            <td class="text-left" data-title="Department Logo">
                                <?php
                                if (file_exists(WWW_ROOT . 'img/departments/' . $department->department_logo) && !empty($department->department_logo)) {

                                    echo '<img src="' . $this->request->getAttribute("webroot") . 'img/departments/' . $department->department_logo . '" style="height:50px">';
                                }
//                                debug();
                                ?>
                            </td>
                            <td class="text-left" data-title="Active"><?= ($department->active) ? '<span style="color:green;">Yes</span>' : '<span style="color:red;">No</span>' ?></td>
                            <td class="text-left" data-title="Department Name"><?= nl2br($department->department_responsibilities) ?></td>

            <!--                            <td class="text-left" data-title="Created"><?= h($department->created) ?></td>
                                        <td class="text-left" data-title="Modified"><?= h($department->modified) ?></td>
                                        <td class="text-right" data-title="Created By"><?= $this->Number->format($department->created_by) ?></td>
                                        <td class="text-right" data-title="Modified By"><?= $this->Number->format($department->modified_by) ?></td>
                                        <td class="text-left" data-title="Deleted"><?= h($department->deleted) ?></td>-->
                            <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-project-diagram"></i> Scheme\'s List (' . count($department->department_schemes) . ')'), ['controller' => 'DepartmentSchemes','action' => 'index', $department->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-users"></i> CPO\'s List (' . count($department->users) . ')'), ['controller' => 'Users', 'action' => 'index', $department->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Details'), ['action' => 'edit', $department->id], ['escape' => false]) ?>
                                <?php $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $department->id], ['confirm' => __('Are you sure you want to delete # {0}?', $department->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
