<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\District $district
 */
$this->assign('title', 'Editing District');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?=
            $this->Form->postLink(
                    __('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $district->id], ['confirm' => __('Are you sure you want to delete # {0}?', ucfirst($district->name)), 'escape' => false]
            )
            ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Districts'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--        <li><?= $this->Html->link(__('List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="districts col-lg-6 content">
        <?= $this->Form->create($district, ['class' => 'form-horizontal']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit District') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-5"><label>' . __('Name') . '</label></div>';
                    echo '<div class="col-7">' . $this->Form->control('name', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-5"><label>' . __('District Type') . '</label></div>';
                    echo '<div class="col-7">';
                    $list = explode(',', $district->type);
//debug($list);
                    echo $this->Form->control('type[]', ['templates' => [
                            'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="parent" class="input-group-append">
                        Provincial
                    </label></div>'
                        ]
                        , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control', 'value' => 'provincial', 'label' => false,
                        in_array('provincial', $list) ? 'checked' : '']);

                    echo $this->Form->control('type[]', ['templates' => [
                            'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="parent" class="input-group-append">
                        Settled
                    </label></div>'
                        ]
                        , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control', 'value' => 'settled', 'label' => false,
                        in_array('settled', $list) ? 'checked' : '']);

                    echo $this->Form->control('type[]', ['templates' => [
                            'inputContainer' => '<div class="checkbox-custom checkbox-default">{{content}}<label for="parent" class="input-group-append">
                        Merged Areas
                    </label></div>'
                        ]
                        , 'type' => 'checkbox', 'hiddenField' => false, 'class' => 'form-control', 'value' => 'merged', 'label' => false,
                        in_array('merged', $list) ? 'checked' : '']);

                    echo '</div>';

//                    echo '<div class="row"><div class="col-5"><label>' . __('Created By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('created_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Modified By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('modified_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Deleted') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('deleted', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>