<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\RecordNoteDetail $recordNoteDetail
 */
   $this->assign('title', 'Editing Record Note Detail');

?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
                        <li><?= $this->Form->postLink(
                __('<i class="fas fa-trash"></i> Delete'),
                ['action' => 'delete', $recordNoteDetail->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $recordNoteDetail->id), 'escape'=>false]
                ) ?></li>
                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Note Details'), ['action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('List Record Notes'), ['controller' => 'RecordNotes', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note'), ['controller' => 'RecordNotes', 'action' => 'add'], ['escape'=>false]) ?></li>
                </ul>
</nav>
<div class="column-responsive column-80">
    <div class="recordNoteDetails col-lg-6 content">
        <?= $this->Form->create($recordNoteDetail, ['class'=>'form-horizontal']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Record Note Detail') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Record Note Id') . '</label></div>';
                        echo '<div class="col-sm-7">' .  $this->Form->control('record_note_id', ['options' => $recordNotes, 'class'=>'form-control' ]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Decision Made') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('decision_made', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Progress Made') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('progress_made', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Timeline') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('timeline', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Notes') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('notes', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Responsibility') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('responsibility', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                            ?>
                        </fieldset>

                    </div><!--card-body-->

                    <footer class="card-footer text-right">
                        <?= $this->Form->button(__('Submit'), ['class'=>'btn btn-primary']) ?>
                        <?= $this->Form->end() ?>
                    </footer>

                </section>
            </div>