<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', 'PCFMS Cost Report');
?>
<style>
    .container {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        min-height: 100vh;
        background-color: #ededed;
    }

    .loader {
        max-width: 2rem;
        width: 100%;
        height: auto;
        stroke-linecap: round;
    }

    circle {
        fill: none;
        stroke-width: 3.5;
        -webkit-animation-name: preloader;
        animation-name: preloader;
        -webkit-animation-duration: 3s;
        animation-duration: 3s;
        -webkit-animation-iteration-count: infinite;
        animation-iteration-count: infinite;
        -webkit-animation-timing-function: ease-in-out;
        animation-timing-function: ease-in-out;
        -webkit-transform-origin: 170px 170px;
        transform-origin: 170px 170px;
        will-change: transform;
    }
    circle:nth-of-type(1) {
        stroke-dasharray: 550;
    }
    circle:nth-of-type(2) {
        stroke-dasharray: 500;
    }
    circle:nth-of-type(3) {
        stroke-dasharray: 450;
    }
    circle:nth-of-type(4) {
        stroke-dasharray: 300;
    }
    circle:nth-of-type(1) {
        -webkit-animation-delay: -0.15s;
        animation-delay: -0.15s;
    }
    circle:nth-of-type(2) {
        -webkit-animation-delay: -0.3s;
        animation-delay: -0.3s;
    }
    circle:nth-of-type(3) {
        -webkit-animation-delay: -0.45s;
        -moz-animation-delay:  -0.45s;
        animation-delay: -0.45s;
    }
    circle:nth-of-type(4) {
        -webkit-animation-delay: -0.6s;
        -moz-animation-delay: -0.6s;
        animation-delay: -0.6s;
    }

    @-webkit-keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

    @keyframes preloader {
        50% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

</style>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-lg-12 content">
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('PCFMS Cost Report') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
//june tak last yeat and july mai current year

                    if (date('m') > 6) {
                        $make_year = date('Y');
                    } else {
                        $make_year = date('Y', strtotime("-1 year"));
                    }
                    $year_array = array();
                    for ($i = $make_year; $i >= 2010; $i--):

                        $year_array[$i] = $i;
                    endfor;
                    ?>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme # (xxxx-xxxxxx Enter number after the - Hyphen)') . '</label></div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('scheme_code', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '<div class="col-sm-2">' . $this->Form->control('year', ['options' => $year_array, 'class' => 'form-control', 'label' => false]) . '</div>';
                    ?>
                    <!--                    <div class="col-sm-1">
                                            
                                        </div>-->
                    <div class="col-sm-3">

                        <input class="btn btn-tertiary pull-left" type='button' value='Fetch Details from PCFMS' />
                        <svg class="loader" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 340 340" style="display:none;float:left;">
                            <circle cx="170" cy="170" r="160" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="135" stroke="#404041"/>
                            <circle cx="170" cy="170" r="110" stroke="#E2007C"/>
                            <circle cx="170" cy="170" r="85" stroke="#404041"/>
                        </svg>
                        <br/><br/>
                    </div>
                    <?php
                    echo '</div><!--/row-->';
                    ?>
                    <div id="result" style="display:none;">
                        <?php
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Name of the scheme') . '</label></div>';
                        echo '<div class="col-sm-7" id="scheme_name"></div>';
                        echo '</div><!--/row-->';
                        
                          echo '<div class="row"><div class="col-sm-5"><label>' . __('Sector Name') . '</label></div>';
                        echo '<div class="col-sm-7" id="sector"></div>';
                        echo '</div><!--/row-->';
                        
                          echo '<div class="row"><div class="col-sm-5"><label>' . __('Sub Sector Name') . '</label></div>';
                        echo '<div class="col-sm-7" id="subsector"></div>';
                        echo '</div><!--/row-->';
                        
                          echo '<div class="row"><div class="col-sm-5"><label>' . __('Approval Date') . '</label></div>';
                        echo '<div class="col-sm-7" id="appr_date"></div>';
                        echo '</div><!--/row-->';
                        
                          echo '<div class="row"><div class="col-sm-5"><label>' . __('Status') . '</label></div>';
                        echo '<div class="col-sm-7" id="status"></div>';
                        echo '</div><!--/row-->';
                        
                          echo '<div class="row"><div class="col-sm-5"><label>' . __('District/Provincial') . '</label></div>';
                        echo '<div class="col-sm-7" id="distt"></div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Type') . '</label></div>';
                        echo '<div class="col-sm-7" id="scheme_type"></div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Geographical coverage of the scheme') . '</label></div>';
                        echo '<div class="col-sm-7" id="geo_coverage"></div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is Foreign Funded?') . '</label></div>';
                        echo '<div class="col-sm-7" id="foreign_funded"></div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Start Date<br/>(From the first consideration/review in PDWP)') . '</label></div>';
                        echo '<div class="col-sm-7" id="scheme_start_date"></div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme End Date') . '</label></div>';
                        echo '<div class="col-sm-7"  id="scheme_end_date"></div>';
                        echo '</div><!--/row-->';
                        ?>
                        <h4>Scheme Financial Progress Details</h4>
                        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered">
                            <tr>
                                <th>Total cost  (in Rs. millions)</th>
                                <td><span id="ttl_cost">&nbsp;</span></td>
                            </tr>
                            <tr>
                                <th>Current allocation  (in Rs. millions)</th>
                                <td><span id="crnt_allocation">&nbsp;</span></td>

                            </tr>
                            <tr>
                                <th>Previous Expenditure  (in Rs. millions)</th>
                                <td><span id="exp_till_date">&nbsp;</span></td>

                            </tr>
                            <tr>
                                <th> Releases Current Year (in Rs. millions)</th>
                                <td><span id="progressive_releases">&nbsp;</span></td>

                            </tr>
                            <tr>
                                <th> Expenditure Current Year (in Rs. millions)</th>
                                <td><span id="progressive_expenditure">&nbsp;</span></td>

                            </tr>
                        </table>

                    </div>
                </fieldset>


            </div><!--card-body-->

            <footer class="card-footer text-right">

            </footer>

        </section>
    </div>
</div>

<script>

    $(function () {

        $('.btn-tertiary').on('click', function () {
//                        alert($('#scheme-number').val());
            //            
            //            return false;

            $('.loader').show();
            var scheme_no = $('#scheme-code').val();
//            if(str.includes("-")){
//                scheme_no=scheme_no.split('-');
//                scheme_no=scheme_no[1];
//            }

            var dd = {YearID: parseInt($('#year').val()), Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_no};
            var myJSON = JSON.stringify(dd);
//            alert(myJSON);
            $.ajax({
                url: "https://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: myJSON,
                dataType: 'json',
                success: function (data) {
                    $('.loader').hide();
//                    alert(data.CODE);
//
//                    alert(data.Message);
//                    alert(data.Data);
//                    return false;
                    if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {

                        if (Object.keys(data.Data.SchemeDetail).length) {
                            $('#result').show('slow');

                            $.each(data.Data.SchemeDetail, function (key, item) {
//                                            alert(key);
                                $('#scheme_name').html(item.SchemeName);
                                if (item.StartDate) {
                                    var d = new Date(item.StartDate)
                                    var s_month = d.getMonth() + 1;
                                    if (s_month.toString().length === 1) {
                                        s_month = '0' + s_month;
                                    }
                                    var s_date = d.getDate() + '-' + s_month + '-' + d.getFullYear();
                                    $('#scheme_start_date').html(s_date);
                                }
                                if (item.EndDate) {
                                    var dd = new Date(item.EndDate);
                                    var e_month = dd.getMonth() + 1;
                                    if (e_month.toString().length === 1) {
                                        e_month = '0' + e_month;
                                    }
//                                alert(e_month.length);
                                    var e_date = dd.getDate() + '-' + e_month + '-' + dd.getFullYear();
                                    $('#scheme_end_date').html(e_date);
                                }
//                            alert(item.Type);
                                if (item.Type.trim() === 'KP') {

                                    $('#scheme_type').html('ADP');
                                    $('#geo_coverage').html('Provincial');
                                } else if (item.Type.trim() === 'MA') {
                                    $('#scheme_type').html('ADP');
                                    $('#geo_coverage').html('Merged');
                                } else {
                                    $('#scheme_type').html('AIP');
                                    $('#geo_coverage').html('Settled');
                                }

                                if (item.IsforeignAided === 'No') {

                                    $('#foreign_funded').html('No');
                                } else {

                                    $('#foreign_funded').html('Yes');
                                }

                                //schemeprofile
                                $('#ttl_cost').html(item.Cost);
                                $('#crnt_allocation').html(item.Allocation);
                                $('#exp_till_date').html(item.previousExp);
                                $('#progressive_releases').html(item.ProgReleases);
//                                alert(item.ProgressiveExp);
                                $('#progressive_expenditure').html(item.ProgressiveExp);
                                
                                
                                $('#sector').html(item.SectorName);
                                $('#subsector').html(item.SubSectorName);
                                if (item.ApprovedDate) {
                                    var dd = new Date(item.ApprovedDate);
                                    var e_month = dd.getMonth() + 1;
                                    if (e_month.toString().length === 1) {
                                        e_month = '0' + e_month;
                                    }
//                                alert(e_month.length);
                                    var e_date = dd.getDate() + '-' + e_month + '-' + dd.getFullYear();
                                    $('#appr_date').html(e_date);
                                }
//                                $('#appr_date').html(item.ApprovedDate);
                                $('#status').html(item.StatusName);
                                $('#distt').html(item.DistrictName);

                            });
                        } else {
                            alert("No scheme found for the mentioned scheme # and year.")
                        }
                    } else {
                        alert(data.CODE + ': ' + data.Message);
                    }
                }, error: function (data) {
                    console.log(data);
                    alert(JSON.stringify(data));
                }
            });
        });

    });
</script>