<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\SchemeStatus[]|\Cake\Collection\CollectionInterface $schemeStatuses
 */
$this->assign('title', 'Listing Scheme Statuses');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['action' => 'add'], ['escape' => false]) ?></li>

        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Scheme Statuses') ?></h3>
        </header>

        <div class="schemeStatuses card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= $this->Paginator->sort('id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('status_name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('status_color_pattern') ?></th>
<!--                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('deleted') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($schemeStatuses as $schemeStatus): ?>
                        <tr>
                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($schemeStatus->id) ?></td>-->
                            <td class="text-left" data-title="Status Name"><?= ucfirst($schemeStatus->status_name) ?></td>
                            <td class="text-left" data-title="Status Color Pattern">
                                <?php
                                if (file_exists(WWW_ROOT . 'img/status_patterns/' . $schemeStatus->status_color_pattern) && !empty($schemeStatus->status_color_pattern)) {

                                    echo '<img src="' . $this->request->getAttribute("webroot") . 'img/status_patterns/' . $schemeStatus->status_color_pattern . '" style="height:50px">';
                                }
                                ?>
                            </td>
<!--                            <td class="text-left" data-title="Created"><?= h($schemeStatus->created) ?></td>
                            <td class="text-left" data-title="Modified"><?= h($schemeStatus->modified) ?></td>
                            <td class="text-right" data-title="Created By"><?= $this->Number->format($schemeStatus->created_by) ?></td>
                            <td class="text-right" data-title="Modified By"><?= $this->Number->format($schemeStatus->modified_by) ?></td>
                            <td class="text-left" data-title="Deleted"><?= h($schemeStatus->deleted) ?></td>-->
                            <td class="actions">
                                <?php $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $schemeStatus->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $schemeStatus->id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $schemeStatus->id], ['confirm' => __('Are you sure you want to delete # {0}?', ucfirst($schemeStatus->status_name)), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
