<?php
$role_id = $myUser['users_roles_id'];

$mTitle = ucfirst($usersRoles["$role_id"]) . ' Dashboard';
$this->assign('title', $mTitle);
?>
<link rel="stylesheet" href="<?php echo $this->request->getAttribute("webroot"); ?>porto-admin/vendor/pnotify/pnotify.custom.css" />
<!-- start: page -->
<section class="call-to-action call-to-action-primary call-to-action-top mb-4">
    <div class="container">
        <div class="row">
            <div class="col-xl-6">
                <div class="call-to-action-content">
                    <h2 class="text-color-light mb-0 mt-4">Welcome <strong><?php echo ucfirst($myUser['fname']); ?> <?php echo ucfirst($myUser['lname']); ?>!</strong></h2>
<!--                    <p class="lead">You are logged in as user level: <?php
                    echo $usersRoles["$role_id"];
                    ?></p>-->
                </div>
            </div>
            <div class="col-xl-6">
                <div class="call-to-action-btn float-right-xl mt-1 pt-1 mt-xl-4 pt-xl-4">
                    <a href="<?php echo $this->request->getAttribute("webroot"); ?>admin/Users/view/" class="btn btn-primary-scale-2 btn-lg">Manage My Profile</a>
                    <span class="d-none d-xl-inline-block">
                        <img src="<?php echo $this->request->getAttribute("webroot"); ?>img/users/<?php echo $myUser['avatar']; ?>" alt="Avatar" width="100" class="dashboard-avatar" />
                        <span class="arrow arrow-light hlb"></span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="section custom-padding">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 mt-3">
                <div class="row">
                    <div class="col-lg-12">
                        <h1 class="center">Resource Center Scheme Viewer</h1>

                        <div class="row">
                            <section class="card col-lg-12">
                                <header class="card-header">
                                    <div class="card-actions">
                                        <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                                        <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                                    </div>
                                    <h3><?= __('Departmental Statistics of Schemes') ?></h3>
                                </header>

                                <div class="departments card-body content">

                                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0"  id="datatable-default">
                                        <thead>
                                            <tr>

                                                <th scope="col">Department Name</th>
                                                <th scope="col" class="text-right">No. of Mega Projects (<span class="dt_total"></span>)</th>
                                                <th scope="col" class="text-right">No. of H. Priority (<span class="dt_green"></span>)</th>
                                                <th scope="col" class="text-right">No. Of DFC-Current Year (<span class="dt_green_yellow"></span>)</th>
                                                <th scope="col" class="text-right">No. of DFC-Two Year  (<span class="dt_red_yellow"></span>)</th>
                                                <!--<th scope="col" class="text-right">No. of After Assembly (<span class="dt_red"></span>)</th>-->
                                                <th scope="col" class="text-right">No. of Normal Schemes  (<span class="dt_white"></span>)</th>


                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_high_priority  = $total_mega= $total_dfc_2_years= $total_dfc_c_year= $total_after_assembly= $total_normal= 0;

                                            foreach ($departments as $department):
                                                $high_priority = $dfc_2_years = $dfc_c_year= $mega = $after_assembly= $normal= 0;

                                            
                                                foreach ($department->department_schemes as $scheme):
                                                    if ($scheme->mega_project=='Yes') {
                                                        $mega += 1;
                                                        $total_mega +=1;
                                                    }
//                                                        debug($scheme->overall_status);
                                                    switch ($scheme->scheme_category) {
                                                        case 'High Priority':
                                                            $high_priority += 1;
                                                            $total_high_priority += 1;
                                                            break;
                                                        case 'DFC (Current Year)':
                                                            $dfc_c_year += 1;
                                                            $total_dfc_c_year += 1;
                                                            break;
                                                        case 'DFC (Two Years)':
                                                            $dfc_2_years += 1;
                                                            $total_dfc_2_years += 1;
                                                            break;
//                                                        case 'After Assembly':
//                                                            $after_assembly += 1;
//                                                            $total_after_assembly += 1;
//                                                            break;
                                                        case 'Normal':
                                                            $normal += 1;
                                                            $total_normal += 1;
                                                            break;
                                                    }
                                                endforeach;
//                    exit; 
                                                ?>
                                                <tr>
                                                    <td class="text-left" data-title="Dept Name"><?= $this->Html->link(__($department->department_name), ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id]); ?></td>
                                                    <td class="text-right" data-title="No. of Mega Projects"><?= $this->Html->link($mega, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=Mega']); ?></td>
                                                    <td class="text-right" data-title="No. of H. Priority"><?= $this->Html->link($high_priority, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=High Priority']); ?></td>
                                                    <td class="text-right" data-title="No. Of DFC-Current Year"><?= $this->Html->link($dfc_c_year, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=DFC (Current Year)']); ?></td>
                                                    <td class="text-right" data-title="No. of DFC-Two Year"><?= $this->Html->link($dfc_2_years, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=DFC (Two Years)']); ?></td>
                                                    <!--<td class="text-right" data-title="No. of After Assembly"><?= $this->Html->link($after_assembly, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=After Assembly']); ?></td>-->
                                                    <td class="text-right" data-title="No. of Normal Schemes"><?= $this->Html->link($normal, ['controller' => 'DepartmentSchemes', 'action' => 'report?department[]=' . $department->id.'&mega_project_search=Normal']); ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <tfoot>
                                            <tr>
                                                <td class="text-left" data-title="Department Name" colspan="7"></td>
                                            </tr>
                                            <tr>
                                                <td class="text-left" data-title="Department Name">Total Schemes&nbsp;</td>
                                                <td class="text-right" data-title="No. of Mega Projects"><?= $this->Html->link(__($total_mega), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=Mega']); ?></td>
                                                <td class="text-right" data-title="No. of H. Priority"><?= $this->Html->link(__($total_high_priority), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=High Priority']); ?></td>
                                                <td class="text-right" data-title="No. Of DFC-Current Year"><?= $this->Html->link(__($total_dfc_c_year), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=DFC (Current Year)']); ?></td>
                                                <td class="text-right" data-title="No. of DFC-Two Year"><?= $this->Html->link(__($total_dfc_2_years), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=DFC (Two Years)']); ?></td>
                                                <!--<td class="text-right" data-title="No. of After Assembly"><?= $this->Html->link(__($total_after_assembly), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=After Assembly']); ?></td>-->
                                                <td class="text-right" data-title="No. of Normal Schemes"><?= $this->Html->link(__($total_normal), ['controller' => 'DepartmentSchemes', 'action' => 'report?mega_project_search=Normal']); ?></td>
                                            </tr>

                                        </tfoot>
                                        </tbody>
                                    </table>
                                </div>
                            </section>
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>
</section>

<script>
    $(function () {
        $('html').removeClass('sidebar-left-collapsed');
        $('.dt_total').html(<?= $total_mega; ?>);
        $('.dt_green').html(<?= $total_high_priority; ?>);
        $('.dt_green_yellow').html(<?= $total_dfc_c_year; ?>);
        $('.dt_red_yellow').html(<?= $total_dfc_2_years; ?>);
        $('.dt_red').html(<?= $total_after_assembly; ?>);
        $('.dt_white').html(<?= $total_normal; ?>);
    });
</script>
