<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
$set_title = 'Viewing User';

$this->assign('title', $set_title);
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $user->id], ['escape' => false]) ?></li>
        <?php if ($user->department_id == '' || $user->department_id == null) { ?>
            <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete User'), ['action' => 'delete', $user->id], ['confirm' => __('Are you sure you want to delete # {0}?', ucwords($user->fname . ' ' . $user->lname)), 'escape' => false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['action' => 'index'], ['escape' => false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['action' => 'add'], ['escape' => false]) ?></li>
        <?php } ?>
<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users Roles'), ['controller' => 'UsersRoles', 'action' => 'index'], ['escape' => false]) ?> </li>
    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Users Role'), ['controller' => 'UsersRoles', 'action' => 'add'], ['escape' => false]) ?> </li>-->
    </ul>
</nav>
<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title"><?= $set_title; ?></h2>
        </header>

        <div class="users card-body content">

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <tr>
                    <th scope="row"><?= __('Attached Formation') ?></th>
                    <td><?= h($user->fname) ?></td>
                </tr>
                 <tr>
                    <th scope="row"><?= __('First Name') ?></th>
                    <td><?= h($user->fname) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Last Name') ?></th>
                    <td><?= h($user->lname) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Email') ?></th>
                    <td><?= h($user->email) ?></td>
                </tr>
<!--                <tr>
                    <th scope="row"><?= __('Password') ?></th>
                    <td><?= h($user->password) ?></td>
                </tr>-->
                <tr>
                    <th scope="row"><?= __('Users Role') ?></th>
                    <td><?= $user->has('users_role') ? ucfirst($user->users_role->id) : '' ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Avatar') ?></th>
                    <td><?php
                        if (file_exists(WWW_ROOT . 'img/users/' . $user->avatar) && !empty($user->avatar)) {

                            echo '<img src="' . $this->request->getAttribute("webroot") . 'img/users/' . $user->avatar . '" style="max-height:100px">';
                        }
                        ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Mobile') ?></th>
                    <td><?= h($user->tel1) ?></td>
                </tr>
<!--                 <tr>
                    <th scope="row"><?= __('Tel2') ?></th>
                    <td><?= h($user->tel2) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Fax') ?></th>
                    <td><?= h($user->fax) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Addr1') ?></th>
                    <td><?= h($user->addr1) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Addr2') ?></th>
                    <td><?= h($user->addr2) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('City') ?></th>
                    <td><?= h($user->city) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('State') ?></th>
                    <td><?= h($user->state) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Postal') ?></th>
                    <td><?= h($user->postal) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Country') ?></th>
                    <td><?= h($user->country) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Id') ?></th>
                    <td><?= $this->Number->format($user->id) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Locked') ?></th>
                    <td><?= ($user->locked) ? '<span style="color:red;">Yes</span>' : '<span style="color:green;">No</span>'; ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Active') ?></th>
                    <td><?= $this->Number->format($user->active) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Login Failures') ?></th>
                    <td><?= $this->Number->format($user->login_failures) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Created By') ?></th>
                    <td><?= $this->Number->format($user->created_by) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Modified By') ?></th>
                    <td><?= $this->Number->format($user->modified_by) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Deleted') ?></th>
                    <td><?= $this->Number->format($user->deleted) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Last Login Failure') ?></th>
                    <td><?= h($user->last_login_failure) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Last Login Success') ?></th>
                    <td><?= h($user->last_login_success) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Created') ?></th>
                    <td><?= h($user->created) ?></td>
                </tr>
                <tr>
                    <th scope="row"><?= __('Modified') ?></th>
                    <td><?= h($user->modified) ?></td>
                </tr>-->
            </table>
            <!--            <div class="row">
                            <h4><?= __('Comments') ?></h4>
            
            <?= $this->Text->autoParagraph(h($user->comments)); ?>
            
                        </div>-->
        </div><!--/content-->
    </section>
</div><!--/row-->
