<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');

$error_list = array();

$geo_coverage = $departmentScheme->geo_coverage ? '' : $this->Html->link(__('Scheme Profile'), ['controller' => 'DepartmentSchemes', 'action' => 'schemeprofile', $departmentScheme->id]);
if ($geo_coverage) {
    array_push($error_list, $geo_coverage);
}

//debug($error_list);exit;
use Cake\ORM\TableRegistry;

$SchemeDistricts = TableRegistry::get('SchemeDistricts');

$choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemeDistricts.department_scheme_id' => $departmentScheme->id]])->count();

$dis = $choosen_nav_districts ? '' : $this->Html->link(__('Relevant Districts?'), ['controller' => 'DepartmentSchemes', 'action' => 'reldistricts', $departmentScheme->id]);
if ($dis) {
    array_push($error_list, $dis);
}
$pc2_required = $departmentScheme->pc2_required ? '' : $this->Html->link(__('Is PC-II required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step1', $departmentScheme->id]);
if ($pc2_required) {
    array_push($error_list, $pc2_required);
}
$pc1_approved = $departmentScheme->pc1_required ? '' : $this->Html->link(__('Is the PC-1 required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step2', $departmentScheme->id]);
if ($pc1_approved) {
    array_push($error_list, $pc1_approved);
}
$hiring_required = $departmentScheme->hiring_required ? '' : $this->Html->link(__('Is hiring required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step3', $departmentScheme->id]);
if ($hiring_required) {
    array_push($error_list, $hiring_required);
}
$land_acquisition_required = $departmentScheme->land_acquisition_required ? '' : $this->Html->link(__('Is land acquisition required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step4', $departmentScheme->id]);
if ($land_acquisition_required) {
    array_push($error_list, $land_acquisition_required);
}
$proc_goods_required = $departmentScheme->proc_goods_required ? '' : $this->Html->link(__('Is procurment of goods required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step5', $departmentScheme->id]);
if ($proc_goods_required) {
    array_push($error_list, $proc_goods_required);
}
$proc_services_required = $departmentScheme->proc_services_required ? '' : $this->Html->link(__('Is procurment of services required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step6', $departmentScheme->id]);
if ($proc_services_required) {
    array_push($error_list, $proc_services_required);
}
$cons_civil_work_required = $departmentScheme->cons_civil_work_required ? '' : $this->Html->link(__('Is construction/civil work required?'), ['controller' => 'DepartmentSchemes', 'action' => 'step7', $departmentScheme->id]);
if ($cons_civil_work_required) {
    array_push($error_list, $cons_civil_work_required);
}
//debug($error_list);exit;
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Schemes'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--        <li><?= $this->Html->link(__('List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Please write any general comments/remarks that you may have.') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('final_comments', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Also attach supporting notification/photographic evidence/ letter (if applicable)') . '</label></div>';

                    echo '<div class="col-sm-7">';
//                        debug($departmentScheme->proc_goods_evidence_of_distribution);
                    if (file_exists(WWW_ROOT . 'img/scheme_files/' . $departmentScheme->scheme_file) && !empty($departmentScheme->scheme_file)) {

                        echo '<strong>Existing Evidence: </strong><img src="' . $this->request->getAttribute("webroot") . 'img/scheme_files/' . $departmentScheme->scheme_file . '" style="max-height:100px">';
                        echo '&nbsp;&nbsp;<a id="delete_evidence" style="color:red;" href="#"><i aria-hidden="true" class="fas fa-trash"></i></a>';
                    }
                    echo $this->Form->control('scheme_file', ['class' => 'form-control', 'label' => false, 'type' => 'file']);
                    echo '</div>';

                    echo '</div><!--/row-->';
                    ?>

                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/add_activity/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <?php
                if ($error_list) {
//                    debug($error_list);exit;
                    echo '<div style="color:red;">Oops, it looks like you haven\'t filled all the required milestones. kindly fill all the below steps and then you can finish this scheme.</div>';

                    foreach ($error_list as $list):
                        echo $list . '<br/>';
                    endforeach;
                } else {
                    ?>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                    <button class="btn btn-primary" type="submit">Save </button>
                <?php } ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>

<script>

    $(function () {

        $('body').on('click', '#delete_evidence', function () {
            if (confirm('Are you sure want to delete?')) {
                window.location.href = '<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/finish_evidence/<?php echo $departmentScheme->id; ?>';
                            }
                        });
                    });
</script>